<?php

namespace MoniFunding\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CommonFundingDataResults StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CommonFundingDataResults
 * @subpackage Structs
 */
class CommonFundingDataResults extends AbstractStructBase
{
    /**
     * The FailureCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FailureCode;
    /**
     * The Success
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Success;
    /**
     * The SuccessMessage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SuccessMessage;
    /**
     * Constructor method for CommonFundingDataResults
     * @uses CommonFundingDataResults::setFailureCode()
     * @uses CommonFundingDataResults::setSuccess()
     * @uses CommonFundingDataResults::setSuccessMessage()
     * @param string $failureCode
     * @param bool $success
     * @param string $successMessage
     */
    public function __construct($failureCode = null, $success = null, $successMessage = null)
    {
        $this
            ->setFailureCode($failureCode)
            ->setSuccess($success)
            ->setSuccessMessage($successMessage);
    }
    /**
     * Get FailureCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFailureCode()
    {
        return isset($this->FailureCode) ? $this->FailureCode : null;
    }
    /**
     * Set FailureCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $failureCode
     * @return \MoniFunding\StructType\CommonFundingDataResults
     */
    public function setFailureCode($failureCode = null)
    {
        // validation for constraint: string
        if (!is_null($failureCode) && !is_string($failureCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($failureCode, true), gettype($failureCode)), __LINE__);
        }
        if (is_null($failureCode) || (is_array($failureCode) && empty($failureCode))) {
            unset($this->FailureCode);
        } else {
            $this->FailureCode = $failureCode;
        }
        return $this;
    }
    /**
     * Get Success value
     * @return bool|null
     */
    public function getSuccess()
    {
        return $this->Success;
    }
    /**
     * Set Success value
     * @param bool $success
     * @return \MoniFunding\StructType\CommonFundingDataResults
     */
    public function setSuccess($success = null)
    {
        // validation for constraint: boolean
        if (!is_null($success) && !is_bool($success)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($success, true), gettype($success)), __LINE__);
        }
        $this->Success = $success;
        return $this;
    }
    /**
     * Get SuccessMessage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSuccessMessage()
    {
        return isset($this->SuccessMessage) ? $this->SuccessMessage : null;
    }
    /**
     * Set SuccessMessage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $successMessage
     * @return \MoniFunding\StructType\CommonFundingDataResults
     */
    public function setSuccessMessage($successMessage = null)
    {
        // validation for constraint: string
        if (!is_null($successMessage) && !is_string($successMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($successMessage, true), gettype($successMessage)), __LINE__);
        }
        if (is_null($successMessage) || (is_array($successMessage) && empty($successMessage))) {
            unset($this->SuccessMessage);
        } else {
            $this->SuccessMessage = $successMessage;
        }
        return $this;
    }
}
