<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Bahnhof StructType
 * @subpackage Structs
 */
class Bahnhof extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 60
     * - minLength: 1
     * - nillable: true
     * @var string
     */
    public $name;
    /**
     * The nummer
     * Meta information extracted from the WSDL
     * - base: xs:int
     * - maxInclusive: 9999999
     * - minInclusive: 1000000
     * - nillable: false
     * @var int
     */
    public $nummer;
    /**
     * Constructor method for Bahnhof
     * @uses Bahnhof::setName()
     * @uses Bahnhof::setNummer()
     * @param string $name
     * @param int $nummer
     */
    public function __construct($name = null, $nummer = null)
    {
        $this
            ->setName($name)
            ->setNummer($nummer);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\Bahnhof
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: maxLength(60)
        if (!is_null($name) && mb_strlen($name) > 60) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 60', mb_strlen($name)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($name) && mb_strlen($name) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get nummer value
     * @return int|null
     */
    public function getNummer()
    {
        return $this->nummer;
    }
    /**
     * Set nummer value
     * @param int $nummer
     * @return \StructType\Bahnhof
     */
    public function setNummer($nummer = null)
    {
        // validation for constraint: int
        if (!is_null($nummer) && !(is_int($nummer) || ctype_digit($nummer))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nummer, true), gettype($nummer)), __LINE__);
        }
        // validation for constraint: maxInclusive(9999999)
        if (!is_null($nummer) && $nummer > 9999999) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 9999999', var_export($nummer, true)), __LINE__);
        }
        // validation for constraint: minInclusive(1000000)
        if (!is_null($nummer) && $nummer < 1000000) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 1000000', var_export($nummer, true)), __LINE__);
        }
        $this->nummer = $nummer;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Bahnhof
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
