<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://rit.bahn.de/webservices/rvabuchung?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://rit.bahn.de/webservices/rvabuchung?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Berechne ServiceType
 */
$berechne = new \ServiceType\Berechne($options);
/**
 * Sample call for berechneEntfernung operation/method
 */
if ($berechne->berechneEntfernung(new \StructType\BerechneEntfernungAnfrage()) !== false) {
    print_r($berechne->getResult());
} else {
    print_r($berechne->getLastError());
}
/**
 * Samples for Buche ServiceType
 */
$buche = new \ServiceType\Buche($options);
/**
 * Sample call for buche operation/method
 */
if ($buche->buche(new \StructType\Buchungsanfrage()) !== false) {
    print_r($buche->getResult());
} else {
    print_r($buche->getLastError());
}
/**
 * Samples for Storniere ServiceType
 */
$storniere = new \ServiceType\Storniere($options);
/**
 * Sample call for storniereBuchung operation/method
 */
if ($storniere->storniereBuchung(new \StructType\StorniereBuchungAnfrage()) !== false) {
    print_r($storniere->getResult());
} else {
    print_r($storniere->getLastError());
}
/**
 * Samples for Suche ServiceType
 */
$suche = new \ServiceType\Suche($options);
/**
 * Sample call for sucheBahnhoefe operation/method
 */
if ($suche->sucheBahnhoefe(new \StructType\SucheBahnhoefeAnfrage()) !== false) {
    print_r($suche->getResult());
} else {
    print_r($suche->getLastError());
}
/**
 * Samples for Verwerfe ServiceType
 */
$verwerfe = new \ServiceType\Verwerfe($options);
/**
 * Sample call for verwerfeBuchung operation/method
 */
if ($verwerfe->verwerfeBuchung(new \StructType\VerwerfeBuchungAnfrage()) !== false) {
    print_r($verwerfe->getResult());
} else {
    print_r($verwerfe->getLastError());
}
