<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VerwerfeBuchungAnfrage StructType
 * @subpackage Structs
 */
class VerwerfeBuchungAnfrage extends Authentisierungsanfrage
{
    /**
     * The buchungsreferenz
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 22
     * - minLength: 1
     * - nillable: false
     * @var string
     */
    public $buchungsreferenz;
    /**
     * Constructor method for VerwerfeBuchungAnfrage
     * @uses VerwerfeBuchungAnfrage::setBuchungsreferenz()
     * @param string $buchungsreferenz
     */
    public function __construct($buchungsreferenz = null)
    {
        $this
            ->setBuchungsreferenz($buchungsreferenz);
    }
    /**
     * Get buchungsreferenz value
     * @return string|null
     */
    public function getBuchungsreferenz()
    {
        return $this->buchungsreferenz;
    }
    /**
     * Set buchungsreferenz value
     * @param string $buchungsreferenz
     * @return \StructType\VerwerfeBuchungAnfrage
     */
    public function setBuchungsreferenz($buchungsreferenz = null)
    {
        // validation for constraint: string
        if (!is_null($buchungsreferenz) && !is_string($buchungsreferenz)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($buchungsreferenz, true), gettype($buchungsreferenz)), __LINE__);
        }
        // validation for constraint: maxLength(22)
        if (!is_null($buchungsreferenz) && mb_strlen($buchungsreferenz) > 22) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 22', mb_strlen($buchungsreferenz)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($buchungsreferenz) && mb_strlen($buchungsreferenz) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($buchungsreferenz)), __LINE__);
        }
        $this->buchungsreferenz = $buchungsreferenz;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VerwerfeBuchungAnfrage
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
