<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StorniereBuchungErgebnis StructType
 * @subpackage Structs
 */
class StorniereBuchungErgebnis extends AbstractStructBase
{
    /**
     * The auftragsstatus
     * Meta information extracted from the WSDL
     * - base: xs:int
     * - maxInclusive: 2
     * - minInclusive: 1
     * @var int
     */
    public $auftragsstatus;
    /**
     * Constructor method for StorniereBuchungErgebnis
     * @uses StorniereBuchungErgebnis::setAuftragsstatus()
     * @param int $auftragsstatus
     */
    public function __construct($auftragsstatus = null)
    {
        $this
            ->setAuftragsstatus($auftragsstatus);
    }
    /**
     * Get auftragsstatus value
     * @return int|null
     */
    public function getAuftragsstatus()
    {
        return $this->auftragsstatus;
    }
    /**
     * Set auftragsstatus value
     * @param int $auftragsstatus
     * @return \StructType\StorniereBuchungErgebnis
     */
    public function setAuftragsstatus($auftragsstatus = null)
    {
        // validation for constraint: int
        if (!is_null($auftragsstatus) && !(is_int($auftragsstatus) || ctype_digit($auftragsstatus))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($auftragsstatus, true), gettype($auftragsstatus)), __LINE__);
        }
        // validation for constraint: maxInclusive(2)
        if (!is_null($auftragsstatus) && $auftragsstatus > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2', var_export($auftragsstatus, true)), __LINE__);
        }
        // validation for constraint: minInclusive(1)
        if (!is_null($auftragsstatus) && $auftragsstatus < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 1', var_export($auftragsstatus, true)), __LINE__);
        }
        $this->auftragsstatus = $auftragsstatus;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StorniereBuchungErgebnis
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
