<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StorniereBuchungAnfrage StructType
 * @subpackage Structs
 */
class StorniereBuchungAnfrage extends Authentisierungsanfrage
{
    /**
     * The auftragsnummer
     * Meta information extracted from the WSDL
     * - base: rva:string6
     * - maxLength: 6
     * - minLength: 6
     * @var string
     */
    public $auftragsnummer;
    /**
     * Constructor method for StorniereBuchungAnfrage
     * @uses StorniereBuchungAnfrage::setAuftragsnummer()
     * @param string $auftragsnummer
     */
    public function __construct($auftragsnummer = null)
    {
        $this
            ->setAuftragsnummer($auftragsnummer);
    }
    /**
     * Get auftragsnummer value
     * @return string|null
     */
    public function getAuftragsnummer()
    {
        return $this->auftragsnummer;
    }
    /**
     * Set auftragsnummer value
     * @param string $auftragsnummer
     * @return \StructType\StorniereBuchungAnfrage
     */
    public function setAuftragsnummer($auftragsnummer = null)
    {
        // validation for constraint: string
        if (!is_null($auftragsnummer) && !is_string($auftragsnummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($auftragsnummer, true), gettype($auftragsnummer)), __LINE__);
        }
        // validation for constraint: maxLength(6)
        if (!is_null($auftragsnummer) && mb_strlen($auftragsnummer) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 6', mb_strlen($auftragsnummer)), __LINE__);
        }
        // validation for constraint: minLength(6)
        if (!is_null($auftragsnummer) && mb_strlen($auftragsnummer) < 6) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 6', mb_strlen($auftragsnummer)), __LINE__);
        }
        $this->auftragsnummer = $auftragsnummer;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StorniereBuchungAnfrage
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
