<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Kundendaten StructType
 * @subpackage Structs
 */
class Kundendaten extends AbstractStructBase
{
    /**
     * The anrede
     * Meta information extracted from the WSDL
     * - base: xs:int
     * - maxInclusive: 2
     * - minInclusive: 0
     * @var int
     */
    public $anrede;
    /**
     * The titel
     * Meta information extracted from the WSDL
     * - base: xs:int
     * - maxInclusive: 3
     * - minInclusive: 0
     * - minOccurs: 0
     * @var int
     */
    public $titel;
    /**
     * The nachname
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $nachname;
    /**
     * The vorname
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $vorname;
    /**
     * The emailAdresse
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $emailAdresse;
    /**
     * The telefonnr
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $telefonnr;
    /**
     * The adresse
     * @var \StructType\Adresse
     */
    public $adresse;
    /**
     * Constructor method for Kundendaten
     * @uses Kundendaten::setAnrede()
     * @uses Kundendaten::setTitel()
     * @uses Kundendaten::setNachname()
     * @uses Kundendaten::setVorname()
     * @uses Kundendaten::setEmailAdresse()
     * @uses Kundendaten::setTelefonnr()
     * @uses Kundendaten::setAdresse()
     * @param int $anrede
     * @param int $titel
     * @param string $nachname
     * @param string $vorname
     * @param string $emailAdresse
     * @param string $telefonnr
     * @param \StructType\Adresse $adresse
     */
    public function __construct($anrede = null, $titel = null, $nachname = null, $vorname = null, $emailAdresse = null, $telefonnr = null, \StructType\Adresse $adresse = null)
    {
        $this
            ->setAnrede($anrede)
            ->setTitel($titel)
            ->setNachname($nachname)
            ->setVorname($vorname)
            ->setEmailAdresse($emailAdresse)
            ->setTelefonnr($telefonnr)
            ->setAdresse($adresse);
    }
    /**
     * Get anrede value
     * @return int|null
     */
    public function getAnrede()
    {
        return $this->anrede;
    }
    /**
     * Set anrede value
     * @param int $anrede
     * @return \StructType\Kundendaten
     */
    public function setAnrede($anrede = null)
    {
        // validation for constraint: int
        if (!is_null($anrede) && !(is_int($anrede) || ctype_digit($anrede))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($anrede, true), gettype($anrede)), __LINE__);
        }
        // validation for constraint: maxInclusive(2)
        if (!is_null($anrede) && $anrede > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2', var_export($anrede, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($anrede) && $anrede < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($anrede, true)), __LINE__);
        }
        $this->anrede = $anrede;
        return $this;
    }
    /**
     * Get titel value
     * @return int|null
     */
    public function getTitel()
    {
        return $this->titel;
    }
    /**
     * Set titel value
     * @param int $titel
     * @return \StructType\Kundendaten
     */
    public function setTitel($titel = null)
    {
        // validation for constraint: int
        if (!is_null($titel) && !(is_int($titel) || ctype_digit($titel))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($titel, true), gettype($titel)), __LINE__);
        }
        // validation for constraint: maxInclusive(3)
        if (!is_null($titel) && $titel > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 3', var_export($titel, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($titel) && $titel < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($titel, true)), __LINE__);
        }
        $this->titel = $titel;
        return $this;
    }
    /**
     * Get nachname value
     * @return string|null
     */
    public function getNachname()
    {
        return $this->nachname;
    }
    /**
     * Set nachname value
     * @param string $nachname
     * @return \StructType\Kundendaten
     */
    public function setNachname($nachname = null)
    {
        // validation for constraint: string
        if (!is_null($nachname) && !is_string($nachname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nachname, true), gettype($nachname)), __LINE__);
        }
        // validation for constraint: maxLength(60)
        if (!is_null($nachname) && mb_strlen($nachname) > 60) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 60', mb_strlen($nachname)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($nachname) && mb_strlen($nachname) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($nachname)), __LINE__);
        }
        $this->nachname = $nachname;
        return $this;
    }
    /**
     * Get vorname value
     * @return string|null
     */
    public function getVorname()
    {
        return $this->vorname;
    }
    /**
     * Set vorname value
     * @param string $vorname
     * @return \StructType\Kundendaten
     */
    public function setVorname($vorname = null)
    {
        // validation for constraint: string
        if (!is_null($vorname) && !is_string($vorname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vorname, true), gettype($vorname)), __LINE__);
        }
        // validation for constraint: maxLength(60)
        if (!is_null($vorname) && mb_strlen($vorname) > 60) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 60', mb_strlen($vorname)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($vorname) && mb_strlen($vorname) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($vorname)), __LINE__);
        }
        $this->vorname = $vorname;
        return $this;
    }
    /**
     * Get emailAdresse value
     * @return string|null
     */
    public function getEmailAdresse()
    {
        return $this->emailAdresse;
    }
    /**
     * Set emailAdresse value
     * @param string $emailAdresse
     * @return \StructType\Kundendaten
     */
    public function setEmailAdresse($emailAdresse = null)
    {
        // validation for constraint: string
        if (!is_null($emailAdresse) && !is_string($emailAdresse)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emailAdresse, true), gettype($emailAdresse)), __LINE__);
        }
        // validation for constraint: maxLength(60)
        if (!is_null($emailAdresse) && mb_strlen($emailAdresse) > 60) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 60', mb_strlen($emailAdresse)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($emailAdresse) && mb_strlen($emailAdresse) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($emailAdresse)), __LINE__);
        }
        $this->emailAdresse = $emailAdresse;
        return $this;
    }
    /**
     * Get telefonnr value
     * @return string|null
     */
    public function getTelefonnr()
    {
        return $this->telefonnr;
    }
    /**
     * Set telefonnr value
     * @param string $telefonnr
     * @return \StructType\Kundendaten
     */
    public function setTelefonnr($telefonnr = null)
    {
        // validation for constraint: string
        if (!is_null($telefonnr) && !is_string($telefonnr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($telefonnr, true), gettype($telefonnr)), __LINE__);
        }
        // validation for constraint: maxLength(60)
        if (!is_null($telefonnr) && mb_strlen($telefonnr) > 60) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 60', mb_strlen($telefonnr)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($telefonnr) && mb_strlen($telefonnr) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($telefonnr)), __LINE__);
        }
        $this->telefonnr = $telefonnr;
        return $this;
    }
    /**
     * Get adresse value
     * @return \StructType\Adresse|null
     */
    public function getAdresse()
    {
        return $this->adresse;
    }
    /**
     * Set adresse value
     * @param \StructType\Adresse $adresse
     * @return \StructType\Kundendaten
     */
    public function setAdresse(\StructType\Adresse $adresse = null)
    {
        $this->adresse = $adresse;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Kundendaten
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
