<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Buchungsergebnis StructType
 * @subpackage Structs
 */
class Buchungsergebnis extends AbstractStructBase
{
    /**
     * The auftragsnummer
     * Meta information extracted from the WSDL
     * - base: rva:string6
     * - maxLength: 6
     * - minLength: 6
     * - nillable: true
     * @var string
     */
    public $auftragsnummer;
    /**
     * The wegetext
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 268
     * - minLength: 1
     * - nillable: true
     * @var string
     */
    public $wegetext;
    /**
     * The letztesStornoDatum
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - nillable: true
     * - pattern: [0-9]{4}-[0-9]{2}-[0-9]{2}
     * @var string
     */
    public $letztesStornoDatum;
    /**
     * The startbahnhofname
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 60
     * - minLength: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $startbahnhofname;
    /**
     * The zielbahnhofname
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 60
     * - minLength: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $zielbahnhofname;
    /**
     * Constructor method for Buchungsergebnis
     * @uses Buchungsergebnis::setAuftragsnummer()
     * @uses Buchungsergebnis::setWegetext()
     * @uses Buchungsergebnis::setLetztesStornoDatum()
     * @uses Buchungsergebnis::setStartbahnhofname()
     * @uses Buchungsergebnis::setZielbahnhofname()
     * @param string $auftragsnummer
     * @param string $wegetext
     * @param string $letztesStornoDatum
     * @param string $startbahnhofname
     * @param string $zielbahnhofname
     */
    public function __construct($auftragsnummer = null, $wegetext = null, $letztesStornoDatum = null, $startbahnhofname = null, $zielbahnhofname = null)
    {
        $this
            ->setAuftragsnummer($auftragsnummer)
            ->setWegetext($wegetext)
            ->setLetztesStornoDatum($letztesStornoDatum)
            ->setStartbahnhofname($startbahnhofname)
            ->setZielbahnhofname($zielbahnhofname);
    }
    /**
     * Get auftragsnummer value
     * @return string|null
     */
    public function getAuftragsnummer()
    {
        return $this->auftragsnummer;
    }
    /**
     * Set auftragsnummer value
     * @param string $auftragsnummer
     * @return \StructType\Buchungsergebnis
     */
    public function setAuftragsnummer($auftragsnummer = null)
    {
        // validation for constraint: string
        if (!is_null($auftragsnummer) && !is_string($auftragsnummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($auftragsnummer, true), gettype($auftragsnummer)), __LINE__);
        }
        // validation for constraint: maxLength(6)
        if (!is_null($auftragsnummer) && mb_strlen($auftragsnummer) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 6', mb_strlen($auftragsnummer)), __LINE__);
        }
        // validation for constraint: minLength(6)
        if (!is_null($auftragsnummer) && mb_strlen($auftragsnummer) < 6) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 6', mb_strlen($auftragsnummer)), __LINE__);
        }
        $this->auftragsnummer = $auftragsnummer;
        return $this;
    }
    /**
     * Get wegetext value
     * @return string|null
     */
    public function getWegetext()
    {
        return $this->wegetext;
    }
    /**
     * Set wegetext value
     * @param string $wegetext
     * @return \StructType\Buchungsergebnis
     */
    public function setWegetext($wegetext = null)
    {
        // validation for constraint: string
        if (!is_null($wegetext) && !is_string($wegetext)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($wegetext, true), gettype($wegetext)), __LINE__);
        }
        // validation for constraint: maxLength(268)
        if (!is_null($wegetext) && mb_strlen($wegetext) > 268) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 268', mb_strlen($wegetext)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($wegetext) && mb_strlen($wegetext) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($wegetext)), __LINE__);
        }
        $this->wegetext = $wegetext;
        return $this;
    }
    /**
     * Get letztesStornoDatum value
     * @return string|null
     */
    public function getLetztesStornoDatum()
    {
        return $this->letztesStornoDatum;
    }
    /**
     * Set letztesStornoDatum value
     * @param string $letztesStornoDatum
     * @return \StructType\Buchungsergebnis
     */
    public function setLetztesStornoDatum($letztesStornoDatum = null)
    {
        // validation for constraint: string
        if (!is_null($letztesStornoDatum) && !is_string($letztesStornoDatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($letztesStornoDatum, true), gettype($letztesStornoDatum)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{4}-[0-9]{2}-[0-9]{2})
        if (!is_null($letztesStornoDatum) && !preg_match('/[0-9]{4}-[0-9]{2}-[0-9]{2}/', $letztesStornoDatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{4}-[0-9]{2}-[0-9]{2}', var_export($letztesStornoDatum, true)), __LINE__);
        }
        $this->letztesStornoDatum = $letztesStornoDatum;
        return $this;
    }
    /**
     * Get startbahnhofname value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStartbahnhofname()
    {
        return isset($this->startbahnhofname) ? $this->startbahnhofname : null;
    }
    /**
     * Set startbahnhofname value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $startbahnhofname
     * @return \StructType\Buchungsergebnis
     */
    public function setStartbahnhofname($startbahnhofname = null)
    {
        // validation for constraint: string
        if (!is_null($startbahnhofname) && !is_string($startbahnhofname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startbahnhofname, true), gettype($startbahnhofname)), __LINE__);
        }
        // validation for constraint: maxLength(60)
        if (!is_null($startbahnhofname) && mb_strlen($startbahnhofname) > 60) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 60', mb_strlen($startbahnhofname)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($startbahnhofname) && mb_strlen($startbahnhofname) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($startbahnhofname)), __LINE__);
        }
        if (is_null($startbahnhofname) || (is_array($startbahnhofname) && empty($startbahnhofname))) {
            unset($this->startbahnhofname);
        } else {
            $this->startbahnhofname = $startbahnhofname;
        }
        return $this;
    }
    /**
     * Get zielbahnhofname value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getZielbahnhofname()
    {
        return isset($this->zielbahnhofname) ? $this->zielbahnhofname : null;
    }
    /**
     * Set zielbahnhofname value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $zielbahnhofname
     * @return \StructType\Buchungsergebnis
     */
    public function setZielbahnhofname($zielbahnhofname = null)
    {
        // validation for constraint: string
        if (!is_null($zielbahnhofname) && !is_string($zielbahnhofname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zielbahnhofname, true), gettype($zielbahnhofname)), __LINE__);
        }
        // validation for constraint: maxLength(60)
        if (!is_null($zielbahnhofname) && mb_strlen($zielbahnhofname) > 60) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 60', mb_strlen($zielbahnhofname)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($zielbahnhofname) && mb_strlen($zielbahnhofname) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($zielbahnhofname)), __LINE__);
        }
        if (is_null($zielbahnhofname) || (is_array($zielbahnhofname) && empty($zielbahnhofname))) {
            unset($this->zielbahnhofname);
        } else {
            $this->zielbahnhofname = $zielbahnhofname;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Buchungsergebnis
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
