<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Buchungsanfrage StructType
 * @subpackage Structs
 */
class Buchungsanfrage extends Authentisierungsanfrage
{
    /**
     * The buchungsreferenz
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 22
     * - minLength: 1
     * - nillable: false
     * @var string
     */
    public $buchungsreferenz;
    /**
     * The vorgangsID
     * Meta information extracted from the WSDL
     * - base: xs:int
     * - maxInclusive: 99999999
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: false
     * @var int
     */
    public $vorgangsID;
    /**
     * The vorgangsID_AN
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 20
     * - minLength: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $vorgangsID_AN;
    /**
     * The kundendaten
     * Meta information extracted from the WSDL
     * - nillable: false
     * @var \StructType\Kundendaten
     */
    public $kundendaten;
    /**
     * The fulfillmentInfo
     * Meta information extracted from the WSDL
     * - nillable: false
     * @var \StructType\FulfillmentInfo
     */
    public $fulfillmentInfo;
    /**
     * The leistungsbeschreibungen
     * Meta information extracted from the WSDL
     * - nillable: false
     * @var \StructType\Leistungsbeschreibungen
     */
    public $leistungsbeschreibungen;
    /**
     * Constructor method for Buchungsanfrage
     * @uses Buchungsanfrage::setBuchungsreferenz()
     * @uses Buchungsanfrage::setVorgangsID()
     * @uses Buchungsanfrage::setVorgangsID_AN()
     * @uses Buchungsanfrage::setKundendaten()
     * @uses Buchungsanfrage::setFulfillmentInfo()
     * @uses Buchungsanfrage::setLeistungsbeschreibungen()
     * @param string $buchungsreferenz
     * @param int $vorgangsID
     * @param string $vorgangsID_AN
     * @param \StructType\Kundendaten $kundendaten
     * @param \StructType\FulfillmentInfo $fulfillmentInfo
     * @param \StructType\Leistungsbeschreibungen $leistungsbeschreibungen
     */
    public function __construct($buchungsreferenz = null, $vorgangsID = null, $vorgangsID_AN = null, \StructType\Kundendaten $kundendaten = null, \StructType\FulfillmentInfo $fulfillmentInfo = null, \StructType\Leistungsbeschreibungen $leistungsbeschreibungen = null)
    {
        $this
            ->setBuchungsreferenz($buchungsreferenz)
            ->setVorgangsID($vorgangsID)
            ->setVorgangsID_AN($vorgangsID_AN)
            ->setKundendaten($kundendaten)
            ->setFulfillmentInfo($fulfillmentInfo)
            ->setLeistungsbeschreibungen($leistungsbeschreibungen);
    }
    /**
     * Get buchungsreferenz value
     * @return string|null
     */
    public function getBuchungsreferenz()
    {
        return $this->buchungsreferenz;
    }
    /**
     * Set buchungsreferenz value
     * @param string $buchungsreferenz
     * @return \StructType\Buchungsanfrage
     */
    public function setBuchungsreferenz($buchungsreferenz = null)
    {
        // validation for constraint: string
        if (!is_null($buchungsreferenz) && !is_string($buchungsreferenz)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($buchungsreferenz, true), gettype($buchungsreferenz)), __LINE__);
        }
        // validation for constraint: maxLength(22)
        if (!is_null($buchungsreferenz) && mb_strlen($buchungsreferenz) > 22) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 22', mb_strlen($buchungsreferenz)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($buchungsreferenz) && mb_strlen($buchungsreferenz) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($buchungsreferenz)), __LINE__);
        }
        $this->buchungsreferenz = $buchungsreferenz;
        return $this;
    }
    /**
     * Get vorgangsID value
     * @return int|null
     */
    public function getVorgangsID()
    {
        return $this->vorgangsID;
    }
    /**
     * Set vorgangsID value
     * @param int $vorgangsID
     * @return \StructType\Buchungsanfrage
     */
    public function setVorgangsID($vorgangsID = null)
    {
        // validation for constraint: int
        if (!is_null($vorgangsID) && !(is_int($vorgangsID) || ctype_digit($vorgangsID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($vorgangsID, true), gettype($vorgangsID)), __LINE__);
        }
        // validation for constraint: maxInclusive(99999999)
        if (!is_null($vorgangsID) && $vorgangsID > 99999999) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 99999999', var_export($vorgangsID, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($vorgangsID) && $vorgangsID < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($vorgangsID, true)), __LINE__);
        }
        $this->vorgangsID = $vorgangsID;
        return $this;
    }
    /**
     * Get vorgangsID_AN value
     * @return string|null
     */
    public function getVorgangsID_AN()
    {
        return $this->vorgangsID_AN;
    }
    /**
     * Set vorgangsID_AN value
     * @param string $vorgangsID_AN
     * @return \StructType\Buchungsanfrage
     */
    public function setVorgangsID_AN($vorgangsID_AN = null)
    {
        // validation for constraint: string
        if (!is_null($vorgangsID_AN) && !is_string($vorgangsID_AN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vorgangsID_AN, true), gettype($vorgangsID_AN)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($vorgangsID_AN) && mb_strlen($vorgangsID_AN) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($vorgangsID_AN)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($vorgangsID_AN) && mb_strlen($vorgangsID_AN) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($vorgangsID_AN)), __LINE__);
        }
        $this->vorgangsID_AN = $vorgangsID_AN;
        return $this;
    }
    /**
     * Get kundendaten value
     * @return \StructType\Kundendaten|null
     */
    public function getKundendaten()
    {
        return $this->kundendaten;
    }
    /**
     * Set kundendaten value
     * @param \StructType\Kundendaten $kundendaten
     * @return \StructType\Buchungsanfrage
     */
    public function setKundendaten(\StructType\Kundendaten $kundendaten = null)
    {
        $this->kundendaten = $kundendaten;
        return $this;
    }
    /**
     * Get fulfillmentInfo value
     * @return \StructType\FulfillmentInfo|null
     */
    public function getFulfillmentInfo()
    {
        return $this->fulfillmentInfo;
    }
    /**
     * Set fulfillmentInfo value
     * @param \StructType\FulfillmentInfo $fulfillmentInfo
     * @return \StructType\Buchungsanfrage
     */
    public function setFulfillmentInfo(\StructType\FulfillmentInfo $fulfillmentInfo = null)
    {
        $this->fulfillmentInfo = $fulfillmentInfo;
        return $this;
    }
    /**
     * Get leistungsbeschreibungen value
     * @return \StructType\Leistungsbeschreibungen|null
     */
    public function getLeistungsbeschreibungen()
    {
        return $this->leistungsbeschreibungen;
    }
    /**
     * Set leistungsbeschreibungen value
     * @param \StructType\Leistungsbeschreibungen $leistungsbeschreibungen
     * @return \StructType\Buchungsanfrage
     */
    public function setLeistungsbeschreibungen(\StructType\Leistungsbeschreibungen $leistungsbeschreibungen = null)
    {
        $this->leistungsbeschreibungen = $leistungsbeschreibungen;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Buchungsanfrage
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
