<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BerechneEntfernungErgebnis StructType
 * @subpackage Structs
 */
class BerechneEntfernungErgebnis extends AbstractStructBase
{
    /**
     * The entfernung
     * Meta information extracted from the WSDL
     * - base: xs:int
     * - maxInclusive: 9999
     * - minInclusive: 0
     * - nillable: false
     * @var int
     */
    public $entfernung;
    /**
     * The wegetext
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 268
     * - minLength: 1
     * - nillable: true
     * @var string
     */
    public $wegetext;
    /**
     * Constructor method for BerechneEntfernungErgebnis
     * @uses BerechneEntfernungErgebnis::setEntfernung()
     * @uses BerechneEntfernungErgebnis::setWegetext()
     * @param int $entfernung
     * @param string $wegetext
     */
    public function __construct($entfernung = null, $wegetext = null)
    {
        $this
            ->setEntfernung($entfernung)
            ->setWegetext($wegetext);
    }
    /**
     * Get entfernung value
     * @return int|null
     */
    public function getEntfernung()
    {
        return $this->entfernung;
    }
    /**
     * Set entfernung value
     * @param int $entfernung
     * @return \StructType\BerechneEntfernungErgebnis
     */
    public function setEntfernung($entfernung = null)
    {
        // validation for constraint: int
        if (!is_null($entfernung) && !(is_int($entfernung) || ctype_digit($entfernung))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($entfernung, true), gettype($entfernung)), __LINE__);
        }
        // validation for constraint: maxInclusive(9999)
        if (!is_null($entfernung) && $entfernung > 9999) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 9999', var_export($entfernung, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($entfernung) && $entfernung < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($entfernung, true)), __LINE__);
        }
        $this->entfernung = $entfernung;
        return $this;
    }
    /**
     * Get wegetext value
     * @return string|null
     */
    public function getWegetext()
    {
        return $this->wegetext;
    }
    /**
     * Set wegetext value
     * @param string $wegetext
     * @return \StructType\BerechneEntfernungErgebnis
     */
    public function setWegetext($wegetext = null)
    {
        // validation for constraint: string
        if (!is_null($wegetext) && !is_string($wegetext)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($wegetext, true), gettype($wegetext)), __LINE__);
        }
        // validation for constraint: maxLength(268)
        if (!is_null($wegetext) && mb_strlen($wegetext) > 268) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 268', mb_strlen($wegetext)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($wegetext) && mb_strlen($wegetext) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($wegetext)), __LINE__);
        }
        $this->wegetext = $wegetext;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BerechneEntfernungErgebnis
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
