<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Authentisierungsanfrage StructType
 * @subpackage Structs
 */
class Authentisierungsanfrage extends Anfrage
{
    /**
     * The benutzername
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 40
     * - minLength: 1
     * - nillable: false
     * @var string
     */
    public $benutzername;
    /**
     * The passwort
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 40
     * - minLength: 1
     * - nillable: false
     * @var string
     */
    public $passwort;
    /**
     * Constructor method for Authentisierungsanfrage
     * @uses Authentisierungsanfrage::setBenutzername()
     * @uses Authentisierungsanfrage::setPasswort()
     * @param string $benutzername
     * @param string $passwort
     */
    public function __construct($benutzername = null, $passwort = null)
    {
        $this
            ->setBenutzername($benutzername)
            ->setPasswort($passwort);
    }
    /**
     * Get benutzername value
     * @return string|null
     */
    public function getBenutzername()
    {
        return $this->benutzername;
    }
    /**
     * Set benutzername value
     * @param string $benutzername
     * @return \StructType\Authentisierungsanfrage
     */
    public function setBenutzername($benutzername = null)
    {
        // validation for constraint: string
        if (!is_null($benutzername) && !is_string($benutzername)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($benutzername, true), gettype($benutzername)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($benutzername) && mb_strlen($benutzername) > 40) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen($benutzername)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($benutzername) && mb_strlen($benutzername) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($benutzername)), __LINE__);
        }
        $this->benutzername = $benutzername;
        return $this;
    }
    /**
     * Get passwort value
     * @return string|null
     */
    public function getPasswort()
    {
        return $this->passwort;
    }
    /**
     * Set passwort value
     * @param string $passwort
     * @return \StructType\Authentisierungsanfrage
     */
    public function setPasswort($passwort = null)
    {
        // validation for constraint: string
        if (!is_null($passwort) && !is_string($passwort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($passwort, true), gettype($passwort)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($passwort) && mb_strlen($passwort) > 40) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen($passwort)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($passwort) && mb_strlen($passwort) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($passwort)), __LINE__);
        }
        $this->passwort = $passwort;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Authentisierungsanfrage
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
