<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Adresse StructType
 * @subpackage Structs
 */
class Adresse extends AbstractStructBase
{
    /**
     * The strasseHausnr
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $strasseHausnr;
    /**
     * The postleitzahl
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 10
     * - minLength: 1
     * @var string
     */
    public $postleitzahl;
    /**
     * The ort
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $ort;
    /**
     * The laendercode
     * Meta information extracted from the WSDL
     * - base: rva:string3
     * - maxLength: 3
     * - minLength: 3
     * @var string
     */
    public $laendercode;
    /**
     * The staatProvinz
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 60
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $staatProvinz;
    /**
     * The adresszusatz
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 30
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $adresszusatz;
    /**
     * Constructor method for Adresse
     * @uses Adresse::setStrasseHausnr()
     * @uses Adresse::setPostleitzahl()
     * @uses Adresse::setOrt()
     * @uses Adresse::setLaendercode()
     * @uses Adresse::setStaatProvinz()
     * @uses Adresse::setAdresszusatz()
     * @param string $strasseHausnr
     * @param string $postleitzahl
     * @param string $ort
     * @param string $laendercode
     * @param string $staatProvinz
     * @param string $adresszusatz
     */
    public function __construct($strasseHausnr = null, $postleitzahl = null, $ort = null, $laendercode = null, $staatProvinz = null, $adresszusatz = null)
    {
        $this
            ->setStrasseHausnr($strasseHausnr)
            ->setPostleitzahl($postleitzahl)
            ->setOrt($ort)
            ->setLaendercode($laendercode)
            ->setStaatProvinz($staatProvinz)
            ->setAdresszusatz($adresszusatz);
    }
    /**
     * Get strasseHausnr value
     * @return string|null
     */
    public function getStrasseHausnr()
    {
        return $this->strasseHausnr;
    }
    /**
     * Set strasseHausnr value
     * @param string $strasseHausnr
     * @return \StructType\Adresse
     */
    public function setStrasseHausnr($strasseHausnr = null)
    {
        // validation for constraint: string
        if (!is_null($strasseHausnr) && !is_string($strasseHausnr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($strasseHausnr, true), gettype($strasseHausnr)), __LINE__);
        }
        // validation for constraint: maxLength(60)
        if (!is_null($strasseHausnr) && mb_strlen($strasseHausnr) > 60) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 60', mb_strlen($strasseHausnr)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($strasseHausnr) && mb_strlen($strasseHausnr) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($strasseHausnr)), __LINE__);
        }
        $this->strasseHausnr = $strasseHausnr;
        return $this;
    }
    /**
     * Get postleitzahl value
     * @return string|null
     */
    public function getPostleitzahl()
    {
        return $this->postleitzahl;
    }
    /**
     * Set postleitzahl value
     * @param string $postleitzahl
     * @return \StructType\Adresse
     */
    public function setPostleitzahl($postleitzahl = null)
    {
        // validation for constraint: string
        if (!is_null($postleitzahl) && !is_string($postleitzahl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postleitzahl, true), gettype($postleitzahl)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($postleitzahl) && mb_strlen($postleitzahl) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($postleitzahl)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($postleitzahl) && mb_strlen($postleitzahl) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($postleitzahl)), __LINE__);
        }
        $this->postleitzahl = $postleitzahl;
        return $this;
    }
    /**
     * Get ort value
     * @return string|null
     */
    public function getOrt()
    {
        return $this->ort;
    }
    /**
     * Set ort value
     * @param string $ort
     * @return \StructType\Adresse
     */
    public function setOrt($ort = null)
    {
        // validation for constraint: string
        if (!is_null($ort) && !is_string($ort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ort, true), gettype($ort)), __LINE__);
        }
        // validation for constraint: maxLength(60)
        if (!is_null($ort) && mb_strlen($ort) > 60) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 60', mb_strlen($ort)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($ort) && mb_strlen($ort) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($ort)), __LINE__);
        }
        $this->ort = $ort;
        return $this;
    }
    /**
     * Get laendercode value
     * @return string|null
     */
    public function getLaendercode()
    {
        return $this->laendercode;
    }
    /**
     * Set laendercode value
     * @param string $laendercode
     * @return \StructType\Adresse
     */
    public function setLaendercode($laendercode = null)
    {
        // validation for constraint: string
        if (!is_null($laendercode) && !is_string($laendercode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($laendercode, true), gettype($laendercode)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($laendercode) && mb_strlen($laendercode) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($laendercode)), __LINE__);
        }
        // validation for constraint: minLength(3)
        if (!is_null($laendercode) && mb_strlen($laendercode) < 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 3', mb_strlen($laendercode)), __LINE__);
        }
        $this->laendercode = $laendercode;
        return $this;
    }
    /**
     * Get staatProvinz value
     * @return string|null
     */
    public function getStaatProvinz()
    {
        return $this->staatProvinz;
    }
    /**
     * Set staatProvinz value
     * @param string $staatProvinz
     * @return \StructType\Adresse
     */
    public function setStaatProvinz($staatProvinz = null)
    {
        // validation for constraint: string
        if (!is_null($staatProvinz) && !is_string($staatProvinz)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($staatProvinz, true), gettype($staatProvinz)), __LINE__);
        }
        // validation for constraint: maxLength(60)
        if (!is_null($staatProvinz) && mb_strlen($staatProvinz) > 60) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 60', mb_strlen($staatProvinz)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($staatProvinz) && mb_strlen($staatProvinz) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($staatProvinz)), __LINE__);
        }
        $this->staatProvinz = $staatProvinz;
        return $this;
    }
    /**
     * Get adresszusatz value
     * @return string|null
     */
    public function getAdresszusatz()
    {
        return $this->adresszusatz;
    }
    /**
     * Set adresszusatz value
     * @param string $adresszusatz
     * @return \StructType\Adresse
     */
    public function setAdresszusatz($adresszusatz = null)
    {
        // validation for constraint: string
        if (!is_null($adresszusatz) && !is_string($adresszusatz)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adresszusatz, true), gettype($adresszusatz)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($adresszusatz) && mb_strlen($adresszusatz) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($adresszusatz)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($adresszusatz) && mb_strlen($adresszusatz) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($adresszusatz)), __LINE__);
        }
        $this->adresszusatz = $adresszusatz;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Adresse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
