<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Verwerfe ServiceType
 * @subpackage Services
 */
class Verwerfe extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named verwerfeBuchung
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\VerwerfeBuchungAnfrage $verwerfeBuchungAnfrage
     * @return \StructType\VerwerfeBuchungErgebnis|bool
     */
    public function verwerfeBuchung(\StructType\VerwerfeBuchungAnfrage $verwerfeBuchungAnfrage)
    {
        try {
            $this->setResult($this->getSoapClient()->verwerfeBuchung($verwerfeBuchungAnfrage));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\VerwerfeBuchungErgebnis
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
