<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Suche ServiceType
 * @subpackage Services
 */
class Suche extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named sucheBahnhoefe
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SucheBahnhoefeAnfrage $sucheBahnhoefeAnfrage
     * @return \StructType\SucheBahnhoefeErgebnis|bool
     */
    public function sucheBahnhoefe(\StructType\SucheBahnhoefeAnfrage $sucheBahnhoefeAnfrage)
    {
        try {
            $this->setResult($this->getSoapClient()->sucheBahnhoefe($sucheBahnhoefeAnfrage));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SucheBahnhoefeErgebnis
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
