<?php

namespace EnumType;

/**
 * This class stands for version EnumType
 * @subpackage Enumerations
 */
class Version
{
    /**
     * Constant for value '1.0'
     * @return string '1.0'
     */
    const VALUE_1_0 = '1.0';
    /**
     * Constant for value '1.1'
     * @return string '1.1'
     */
    const VALUE_1_1 = '1.1';
    /**
     * Constant for value '1.2'
     * @return string '1.2'
     */
    const VALUE_1_2 = '1.2';
    /**
     * Constant for value '1.3'
     * @return string '1.3'
     */
    const VALUE_1_3 = '1.3';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_1_0
     * @uses self::VALUE_1_1
     * @uses self::VALUE_1_2
     * @uses self::VALUE_1_3
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_1_0,
            self::VALUE_1_1,
            self::VALUE_1_2,
            self::VALUE_1_3,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
