<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SucheBahnhoefeAnfrage StructType
 * @subpackage Structs
 */
class SucheBahnhoefeAnfrage extends Anfrage
{
    /**
     * The bahnhofsname
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 60
     * - minLength: 1
     * - nillable: false
     * @var string
     */
    public $bahnhofsname;
    /**
     * Constructor method for SucheBahnhoefeAnfrage
     * @uses SucheBahnhoefeAnfrage::setBahnhofsname()
     * @param string $bahnhofsname
     */
    public function __construct($bahnhofsname = null)
    {
        $this
            ->setBahnhofsname($bahnhofsname);
    }
    /**
     * Get bahnhofsname value
     * @return string|null
     */
    public function getBahnhofsname()
    {
        return $this->bahnhofsname;
    }
    /**
     * Set bahnhofsname value
     * @param string $bahnhofsname
     * @return \StructType\SucheBahnhoefeAnfrage
     */
    public function setBahnhofsname($bahnhofsname = null)
    {
        // validation for constraint: string
        if (!is_null($bahnhofsname) && !is_string($bahnhofsname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bahnhofsname, true), gettype($bahnhofsname)), __LINE__);
        }
        // validation for constraint: maxLength(60)
        if (!is_null($bahnhofsname) && mb_strlen($bahnhofsname) > 60) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 60', mb_strlen($bahnhofsname)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($bahnhofsname) && mb_strlen($bahnhofsname) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($bahnhofsname)), __LINE__);
        }
        $this->bahnhofsname = $bahnhofsname;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SucheBahnhoefeAnfrage
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
