<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SoapFaultDetails StructType
 * @subpackage Structs
 */
class SoapFaultDetails extends AbstractStructBase
{
    /**
     * The code
     * Meta information extracted from the WSDL
     * - nillable: false
     * @var int
     */
    public $code;
    /**
     * The class
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $class;
    /**
     * The callid
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $callid;
    /**
     * The timestamp
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $timestamp;
    /**
     * The params
     * Meta information extracted from the WSDL
     * - arrayType: xs:string[]
     * - base: soapenc:Array
     * - nillable: true
     * - ref: soapenc:arrayType
     * @var string[]
     */
    public $params;
    /**
     * Constructor method for SoapFaultDetails
     * @uses SoapFaultDetails::setCode()
     * @uses SoapFaultDetails::setClass()
     * @uses SoapFaultDetails::setCallid()
     * @uses SoapFaultDetails::setTimestamp()
     * @uses SoapFaultDetails::setParams()
     * @param int $code
     * @param string $class
     * @param string $callid
     * @param string $timestamp
     * @param string[] $params
     */
    public function __construct($code = null, $class = null, $callid = null, $timestamp = null, array $params = array())
    {
        $this
            ->setCode($code)
            ->setClass($class)
            ->setCallid($callid)
            ->setTimestamp($timestamp)
            ->setParams($params);
    }
    /**
     * Get code value
     * @return int|null
     */
    public function getCode()
    {
        return $this->code;
    }
    /**
     * Set code value
     * @param int $code
     * @return \StructType\SoapFaultDetails
     */
    public function setCode($code = null)
    {
        // validation for constraint: int
        if (!is_null($code) && !(is_int($code) || ctype_digit($code))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->code = $code;
        return $this;
    }
    /**
     * Get class value
     * @return string|null
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @param string $class
     * @return \StructType\SoapFaultDetails
     */
    public function setClass($class = null)
    {
        // validation for constraint: string
        if (!is_null($class) && !is_string($class)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($class, true), gettype($class)), __LINE__);
        }
        $this->class = $class;
        return $this;
    }
    /**
     * Get callid value
     * @return string|null
     */
    public function getCallid()
    {
        return $this->callid;
    }
    /**
     * Set callid value
     * @param string $callid
     * @return \StructType\SoapFaultDetails
     */
    public function setCallid($callid = null)
    {
        // validation for constraint: string
        if (!is_null($callid) && !is_string($callid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($callid, true), gettype($callid)), __LINE__);
        }
        $this->callid = $callid;
        return $this;
    }
    /**
     * Get timestamp value
     * @return string|null
     */
    public function getTimestamp()
    {
        return $this->timestamp;
    }
    /**
     * Set timestamp value
     * @param string $timestamp
     * @return \StructType\SoapFaultDetails
     */
    public function setTimestamp($timestamp = null)
    {
        // validation for constraint: string
        if (!is_null($timestamp) && !is_string($timestamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timestamp, true), gettype($timestamp)), __LINE__);
        }
        $this->timestamp = $timestamp;
        return $this;
    }
    /**
     * Get params value
     * @return string[]|null
     */
    public function getParams()
    {
        return $this->params;
    }
    /**
     * This method is responsible for validating the values passed to the setParams method
     * This method is willingly generated in order to preserve the one-line inline validation within the setParams method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateParamsForArrayConstraintsFromSetParams(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $soapFaultDetailsParamsItem) {
            // validation for constraint: itemType
            if (!is_string($soapFaultDetailsParamsItem)) {
                $invalidValues[] = is_object($soapFaultDetailsParamsItem) ? get_class($soapFaultDetailsParamsItem) : sprintf('%s(%s)', gettype($soapFaultDetailsParamsItem), var_export($soapFaultDetailsParamsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The params property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set params value
     * @throws \InvalidArgumentException
     * @param string[] $params
     * @return \StructType\SoapFaultDetails
     */
    public function setParams(array $params = array())
    {
        // validation for constraint: array
        if ('' !== ($paramsArrayErrorMessage = self::validateParamsForArrayConstraintsFromSetParams($params))) {
            throw new \InvalidArgumentException($paramsArrayErrorMessage, __LINE__);
        }
        $this->params = $params;
        return $this;
    }
    /**
     * Add item to params value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\SoapFaultDetails
     */
    public function addToParams($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The params property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->params[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SoapFaultDetails
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
