<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RVATicketbeschreibung StructType
 * @subpackage Structs
 */
class RVATicketbeschreibung extends AbstractStructBase
{
    /**
     * The tarif
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 7
     * - minLength: 5
     * - nillable: false
     * @var string
     */
    public $tarif;
    /**
     * The startbahnhof
     * Meta information extracted from the WSDL
     * - base: xs:int
     * - maxInclusive: 9999999
     * - minInclusive: 1000000
     * - nillable: false
     * @var int
     */
    public $startbahnhof;
    /**
     * The zielbahnhof
     * Meta information extracted from the WSDL
     * - base: xs:int
     * - maxInclusive: 9999999
     * - minInclusive: 1000000
     * - nillable: false
     * @var int
     */
    public $zielbahnhof;
    /**
     * The via1
     * Meta information extracted from the WSDL
     * - base: xs:int
     * - maxInclusive: 9999999
     * - minInclusive: 1000000
     * - minOccurs: 0
     * - nillable: false
     * @var int
     */
    public $via1;
    /**
     * The via2
     * Meta information extracted from the WSDL
     * - base: xs:int
     * - maxInclusive: 9999999
     * - minInclusive: 1000000
     * - minOccurs: 0
     * - nillable: false
     * @var int
     */
    public $via2;
    /**
     * The via1Rueck
     * Meta information extracted from the WSDL
     * - base: xs:int
     * - maxInclusive: 9999999
     * - minInclusive: 1000000
     * - minOccurs: 0
     * - nillable: false
     * @var int
     */
    public $via1Rueck;
    /**
     * The via2Rueck
     * Meta information extracted from the WSDL
     * - base: xs:int
     * - maxInclusive: 9999999
     * - minInclusive: 1000000
     * - minOccurs: 0
     * - nillable: false
     * @var int
     */
    public $via2Rueck;
    /**
     * The gueltigAb
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - nillable: false
     * - pattern: [0-9]{4}-[0-9]{2}-[0-9]{2}
     * @var string
     */
    public $gueltigAb;
    /**
     * The klasse
     * Meta information extracted from the WSDL
     * - base: xs:int
     * - maxInclusive: 2
     * - minInclusive: 1
     * - nillable: false
     * @var int
     */
    public $klasse;
    /**
     * The anzahlErwMitBC
     * Meta information extracted from the WSDL
     * - base: xs:int
     * - maxInclusive: 99
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: false
     * @var int
     */
    public $anzahlErwMitBC;
    /**
     * The anzahlErwOhneBC
     * Meta information extracted from the WSDL
     * - base: xs:int
     * - maxInclusive: 99
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: false
     * @var int
     */
    public $anzahlErwOhneBC;
    /**
     * The anzahlKinder
     * Meta information extracted from the WSDL
     * - base: xs:int
     * - maxInclusive: 99
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: false
     * @var int
     */
    public $anzahlKinder;
    /**
     * Constructor method for RVATicketbeschreibung
     * @uses RVATicketbeschreibung::setTarif()
     * @uses RVATicketbeschreibung::setStartbahnhof()
     * @uses RVATicketbeschreibung::setZielbahnhof()
     * @uses RVATicketbeschreibung::setVia1()
     * @uses RVATicketbeschreibung::setVia2()
     * @uses RVATicketbeschreibung::setVia1Rueck()
     * @uses RVATicketbeschreibung::setVia2Rueck()
     * @uses RVATicketbeschreibung::setGueltigAb()
     * @uses RVATicketbeschreibung::setKlasse()
     * @uses RVATicketbeschreibung::setAnzahlErwMitBC()
     * @uses RVATicketbeschreibung::setAnzahlErwOhneBC()
     * @uses RVATicketbeschreibung::setAnzahlKinder()
     * @param string $tarif
     * @param int $startbahnhof
     * @param int $zielbahnhof
     * @param int $via1
     * @param int $via2
     * @param int $via1Rueck
     * @param int $via2Rueck
     * @param string $gueltigAb
     * @param int $klasse
     * @param int $anzahlErwMitBC
     * @param int $anzahlErwOhneBC
     * @param int $anzahlKinder
     */
    public function __construct($tarif = null, $startbahnhof = null, $zielbahnhof = null, $via1 = null, $via2 = null, $via1Rueck = null, $via2Rueck = null, $gueltigAb = null, $klasse = null, $anzahlErwMitBC = null, $anzahlErwOhneBC = null, $anzahlKinder = null)
    {
        $this
            ->setTarif($tarif)
            ->setStartbahnhof($startbahnhof)
            ->setZielbahnhof($zielbahnhof)
            ->setVia1($via1)
            ->setVia2($via2)
            ->setVia1Rueck($via1Rueck)
            ->setVia2Rueck($via2Rueck)
            ->setGueltigAb($gueltigAb)
            ->setKlasse($klasse)
            ->setAnzahlErwMitBC($anzahlErwMitBC)
            ->setAnzahlErwOhneBC($anzahlErwOhneBC)
            ->setAnzahlKinder($anzahlKinder);
    }
    /**
     * Get tarif value
     * @return string|null
     */
    public function getTarif()
    {
        return $this->tarif;
    }
    /**
     * Set tarif value
     * @param string $tarif
     * @return \StructType\RVATicketbeschreibung
     */
    public function setTarif($tarif = null)
    {
        // validation for constraint: string
        if (!is_null($tarif) && !is_string($tarif)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tarif, true), gettype($tarif)), __LINE__);
        }
        // validation for constraint: maxLength(7)
        if (!is_null($tarif) && mb_strlen($tarif) > 7) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 7', mb_strlen($tarif)), __LINE__);
        }
        // validation for constraint: minLength(5)
        if (!is_null($tarif) && mb_strlen($tarif) < 5) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 5', mb_strlen($tarif)), __LINE__);
        }
        $this->tarif = $tarif;
        return $this;
    }
    /**
     * Get startbahnhof value
     * @return int|null
     */
    public function getStartbahnhof()
    {
        return $this->startbahnhof;
    }
    /**
     * Set startbahnhof value
     * @param int $startbahnhof
     * @return \StructType\RVATicketbeschreibung
     */
    public function setStartbahnhof($startbahnhof = null)
    {
        // validation for constraint: int
        if (!is_null($startbahnhof) && !(is_int($startbahnhof) || ctype_digit($startbahnhof))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($startbahnhof, true), gettype($startbahnhof)), __LINE__);
        }
        // validation for constraint: maxInclusive(9999999)
        if (!is_null($startbahnhof) && $startbahnhof > 9999999) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 9999999', var_export($startbahnhof, true)), __LINE__);
        }
        // validation for constraint: minInclusive(1000000)
        if (!is_null($startbahnhof) && $startbahnhof < 1000000) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 1000000', var_export($startbahnhof, true)), __LINE__);
        }
        $this->startbahnhof = $startbahnhof;
        return $this;
    }
    /**
     * Get zielbahnhof value
     * @return int|null
     */
    public function getZielbahnhof()
    {
        return $this->zielbahnhof;
    }
    /**
     * Set zielbahnhof value
     * @param int $zielbahnhof
     * @return \StructType\RVATicketbeschreibung
     */
    public function setZielbahnhof($zielbahnhof = null)
    {
        // validation for constraint: int
        if (!is_null($zielbahnhof) && !(is_int($zielbahnhof) || ctype_digit($zielbahnhof))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($zielbahnhof, true), gettype($zielbahnhof)), __LINE__);
        }
        // validation for constraint: maxInclusive(9999999)
        if (!is_null($zielbahnhof) && $zielbahnhof > 9999999) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 9999999', var_export($zielbahnhof, true)), __LINE__);
        }
        // validation for constraint: minInclusive(1000000)
        if (!is_null($zielbahnhof) && $zielbahnhof < 1000000) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 1000000', var_export($zielbahnhof, true)), __LINE__);
        }
        $this->zielbahnhof = $zielbahnhof;
        return $this;
    }
    /**
     * Get via1 value
     * @return int|null
     */
    public function getVia1()
    {
        return $this->via1;
    }
    /**
     * Set via1 value
     * @param int $via1
     * @return \StructType\RVATicketbeschreibung
     */
    public function setVia1($via1 = null)
    {
        // validation for constraint: int
        if (!is_null($via1) && !(is_int($via1) || ctype_digit($via1))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($via1, true), gettype($via1)), __LINE__);
        }
        // validation for constraint: maxInclusive(9999999)
        if (!is_null($via1) && $via1 > 9999999) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 9999999', var_export($via1, true)), __LINE__);
        }
        // validation for constraint: minInclusive(1000000)
        if (!is_null($via1) && $via1 < 1000000) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 1000000', var_export($via1, true)), __LINE__);
        }
        $this->via1 = $via1;
        return $this;
    }
    /**
     * Get via2 value
     * @return int|null
     */
    public function getVia2()
    {
        return $this->via2;
    }
    /**
     * Set via2 value
     * @param int $via2
     * @return \StructType\RVATicketbeschreibung
     */
    public function setVia2($via2 = null)
    {
        // validation for constraint: int
        if (!is_null($via2) && !(is_int($via2) || ctype_digit($via2))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($via2, true), gettype($via2)), __LINE__);
        }
        // validation for constraint: maxInclusive(9999999)
        if (!is_null($via2) && $via2 > 9999999) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 9999999', var_export($via2, true)), __LINE__);
        }
        // validation for constraint: minInclusive(1000000)
        if (!is_null($via2) && $via2 < 1000000) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 1000000', var_export($via2, true)), __LINE__);
        }
        $this->via2 = $via2;
        return $this;
    }
    /**
     * Get via1Rueck value
     * @return int|null
     */
    public function getVia1Rueck()
    {
        return $this->via1Rueck;
    }
    /**
     * Set via1Rueck value
     * @param int $via1Rueck
     * @return \StructType\RVATicketbeschreibung
     */
    public function setVia1Rueck($via1Rueck = null)
    {
        // validation for constraint: int
        if (!is_null($via1Rueck) && !(is_int($via1Rueck) || ctype_digit($via1Rueck))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($via1Rueck, true), gettype($via1Rueck)), __LINE__);
        }
        // validation for constraint: maxInclusive(9999999)
        if (!is_null($via1Rueck) && $via1Rueck > 9999999) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 9999999', var_export($via1Rueck, true)), __LINE__);
        }
        // validation for constraint: minInclusive(1000000)
        if (!is_null($via1Rueck) && $via1Rueck < 1000000) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 1000000', var_export($via1Rueck, true)), __LINE__);
        }
        $this->via1Rueck = $via1Rueck;
        return $this;
    }
    /**
     * Get via2Rueck value
     * @return int|null
     */
    public function getVia2Rueck()
    {
        return $this->via2Rueck;
    }
    /**
     * Set via2Rueck value
     * @param int $via2Rueck
     * @return \StructType\RVATicketbeschreibung
     */
    public function setVia2Rueck($via2Rueck = null)
    {
        // validation for constraint: int
        if (!is_null($via2Rueck) && !(is_int($via2Rueck) || ctype_digit($via2Rueck))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($via2Rueck, true), gettype($via2Rueck)), __LINE__);
        }
        // validation for constraint: maxInclusive(9999999)
        if (!is_null($via2Rueck) && $via2Rueck > 9999999) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 9999999', var_export($via2Rueck, true)), __LINE__);
        }
        // validation for constraint: minInclusive(1000000)
        if (!is_null($via2Rueck) && $via2Rueck < 1000000) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 1000000', var_export($via2Rueck, true)), __LINE__);
        }
        $this->via2Rueck = $via2Rueck;
        return $this;
    }
    /**
     * Get gueltigAb value
     * @return string|null
     */
    public function getGueltigAb()
    {
        return $this->gueltigAb;
    }
    /**
     * Set gueltigAb value
     * @param string $gueltigAb
     * @return \StructType\RVATicketbeschreibung
     */
    public function setGueltigAb($gueltigAb = null)
    {
        // validation for constraint: string
        if (!is_null($gueltigAb) && !is_string($gueltigAb)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gueltigAb, true), gettype($gueltigAb)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{4}-[0-9]{2}-[0-9]{2})
        if (!is_null($gueltigAb) && !preg_match('/[0-9]{4}-[0-9]{2}-[0-9]{2}/', $gueltigAb)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{4}-[0-9]{2}-[0-9]{2}', var_export($gueltigAb, true)), __LINE__);
        }
        $this->gueltigAb = $gueltigAb;
        return $this;
    }
    /**
     * Get klasse value
     * @return int|null
     */
    public function getKlasse()
    {
        return $this->klasse;
    }
    /**
     * Set klasse value
     * @param int $klasse
     * @return \StructType\RVATicketbeschreibung
     */
    public function setKlasse($klasse = null)
    {
        // validation for constraint: int
        if (!is_null($klasse) && !(is_int($klasse) || ctype_digit($klasse))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($klasse, true), gettype($klasse)), __LINE__);
        }
        // validation for constraint: maxInclusive(2)
        if (!is_null($klasse) && $klasse > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2', var_export($klasse, true)), __LINE__);
        }
        // validation for constraint: minInclusive(1)
        if (!is_null($klasse) && $klasse < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 1', var_export($klasse, true)), __LINE__);
        }
        $this->klasse = $klasse;
        return $this;
    }
    /**
     * Get anzahlErwMitBC value
     * @return int|null
     */
    public function getAnzahlErwMitBC()
    {
        return $this->anzahlErwMitBC;
    }
    /**
     * Set anzahlErwMitBC value
     * @param int $anzahlErwMitBC
     * @return \StructType\RVATicketbeschreibung
     */
    public function setAnzahlErwMitBC($anzahlErwMitBC = null)
    {
        // validation for constraint: int
        if (!is_null($anzahlErwMitBC) && !(is_int($anzahlErwMitBC) || ctype_digit($anzahlErwMitBC))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($anzahlErwMitBC, true), gettype($anzahlErwMitBC)), __LINE__);
        }
        // validation for constraint: maxInclusive(99)
        if (!is_null($anzahlErwMitBC) && $anzahlErwMitBC > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 99', var_export($anzahlErwMitBC, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($anzahlErwMitBC) && $anzahlErwMitBC < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($anzahlErwMitBC, true)), __LINE__);
        }
        $this->anzahlErwMitBC = $anzahlErwMitBC;
        return $this;
    }
    /**
     * Get anzahlErwOhneBC value
     * @return int|null
     */
    public function getAnzahlErwOhneBC()
    {
        return $this->anzahlErwOhneBC;
    }
    /**
     * Set anzahlErwOhneBC value
     * @param int $anzahlErwOhneBC
     * @return \StructType\RVATicketbeschreibung
     */
    public function setAnzahlErwOhneBC($anzahlErwOhneBC = null)
    {
        // validation for constraint: int
        if (!is_null($anzahlErwOhneBC) && !(is_int($anzahlErwOhneBC) || ctype_digit($anzahlErwOhneBC))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($anzahlErwOhneBC, true), gettype($anzahlErwOhneBC)), __LINE__);
        }
        // validation for constraint: maxInclusive(99)
        if (!is_null($anzahlErwOhneBC) && $anzahlErwOhneBC > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 99', var_export($anzahlErwOhneBC, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($anzahlErwOhneBC) && $anzahlErwOhneBC < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($anzahlErwOhneBC, true)), __LINE__);
        }
        $this->anzahlErwOhneBC = $anzahlErwOhneBC;
        return $this;
    }
    /**
     * Get anzahlKinder value
     * @return int|null
     */
    public function getAnzahlKinder()
    {
        return $this->anzahlKinder;
    }
    /**
     * Set anzahlKinder value
     * @param int $anzahlKinder
     * @return \StructType\RVATicketbeschreibung
     */
    public function setAnzahlKinder($anzahlKinder = null)
    {
        // validation for constraint: int
        if (!is_null($anzahlKinder) && !(is_int($anzahlKinder) || ctype_digit($anzahlKinder))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($anzahlKinder, true), gettype($anzahlKinder)), __LINE__);
        }
        // validation for constraint: maxInclusive(99)
        if (!is_null($anzahlKinder) && $anzahlKinder > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 99', var_export($anzahlKinder, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($anzahlKinder) && $anzahlKinder < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($anzahlKinder, true)), __LINE__);
        }
        $this->anzahlKinder = $anzahlKinder;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RVATicketbeschreibung
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
