<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OnlineticketInfo StructType
 * @subpackage Structs
 */
class OnlineticketInfo extends FulfillmentInfo
{
    /**
     * The ausweisTyp
     * Meta information extracted from the WSDL
     * - base: xs:int
     * - maxInclusive: 10
     * - minInclusive: 1
     * - minOccurs: 0
     * @var int
     */
    public $ausweisTyp;
    /**
     * The ausweisID
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 22
     * - minLength: 7
     * - minOccurs: 0
     * @var string
     */
    public $ausweisID;
    /**
     * The ausweisLand
     * Meta information extracted from the WSDL
     * - base: rva:string3
     * - maxLength: 3
     * - minLength: 3
     * - minOccurs: 0
     * @var string
     */
    public $ausweisLand;
    /**
     * Constructor method for OnlineticketInfo
     * @uses OnlineticketInfo::setAusweisTyp()
     * @uses OnlineticketInfo::setAusweisID()
     * @uses OnlineticketInfo::setAusweisLand()
     * @param int $ausweisTyp
     * @param string $ausweisID
     * @param string $ausweisLand
     */
    public function __construct($ausweisTyp = null, $ausweisID = null, $ausweisLand = null)
    {
        $this
            ->setAusweisTyp($ausweisTyp)
            ->setAusweisID($ausweisID)
            ->setAusweisLand($ausweisLand);
    }
    /**
     * Get ausweisTyp value
     * @return int|null
     */
    public function getAusweisTyp()
    {
        return $this->ausweisTyp;
    }
    /**
     * Set ausweisTyp value
     * @param int $ausweisTyp
     * @return \StructType\OnlineticketInfo
     */
    public function setAusweisTyp($ausweisTyp = null)
    {
        // validation for constraint: int
        if (!is_null($ausweisTyp) && !(is_int($ausweisTyp) || ctype_digit($ausweisTyp))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ausweisTyp, true), gettype($ausweisTyp)), __LINE__);
        }
        // validation for constraint: maxInclusive(10)
        if (!is_null($ausweisTyp) && $ausweisTyp > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 10', var_export($ausweisTyp, true)), __LINE__);
        }
        // validation for constraint: minInclusive(1)
        if (!is_null($ausweisTyp) && $ausweisTyp < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 1', var_export($ausweisTyp, true)), __LINE__);
        }
        $this->ausweisTyp = $ausweisTyp;
        return $this;
    }
    /**
     * Get ausweisID value
     * @return string|null
     */
    public function getAusweisID()
    {
        return $this->ausweisID;
    }
    /**
     * Set ausweisID value
     * @param string $ausweisID
     * @return \StructType\OnlineticketInfo
     */
    public function setAusweisID($ausweisID = null)
    {
        // validation for constraint: string
        if (!is_null($ausweisID) && !is_string($ausweisID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ausweisID, true), gettype($ausweisID)), __LINE__);
        }
        // validation for constraint: maxLength(22)
        if (!is_null($ausweisID) && mb_strlen($ausweisID) > 22) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 22', mb_strlen($ausweisID)), __LINE__);
        }
        // validation for constraint: minLength(7)
        if (!is_null($ausweisID) && mb_strlen($ausweisID) < 7) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 7', mb_strlen($ausweisID)), __LINE__);
        }
        $this->ausweisID = $ausweisID;
        return $this;
    }
    /**
     * Get ausweisLand value
     * @return string|null
     */
    public function getAusweisLand()
    {
        return $this->ausweisLand;
    }
    /**
     * Set ausweisLand value
     * @param string $ausweisLand
     * @return \StructType\OnlineticketInfo
     */
    public function setAusweisLand($ausweisLand = null)
    {
        // validation for constraint: string
        if (!is_null($ausweisLand) && !is_string($ausweisLand)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ausweisLand, true), gettype($ausweisLand)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($ausweisLand) && mb_strlen($ausweisLand) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($ausweisLand)), __LINE__);
        }
        // validation for constraint: minLength(3)
        if (!is_null($ausweisLand) && mb_strlen($ausweisLand) < 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 3', mb_strlen($ausweisLand)), __LINE__);
        }
        $this->ausweisLand = $ausweisLand;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OnlineticketInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
