<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Anfrage StructType
 * @subpackage Structs
 */
class Anfrage extends AbstractStructBase
{
    /**
     * The version
     * Meta information extracted from the WSDL
     * - default: 1.0
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $version;
    /**
     * Constructor method for Anfrage
     * @uses Anfrage::setVersion()
     * @param string $version
     */
    public function __construct($version = '1.0')
    {
        $this
            ->setVersion($version);
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @uses \EnumType\Version::valueIsValid()
     * @uses \EnumType\Version::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $version
     * @return \StructType\Anfrage
     */
    public function setVersion($version = '1.0')
    {
        // validation for constraint: enumeration
        if (!\EnumType\Version::valueIsValid($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Version', is_array($version) ? implode(', ', $version) : var_export($version, true), implode(', ', \EnumType\Version::getValidValues())), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Anfrage
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
