<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Berechne ServiceType
 * @subpackage Services
 */
class Berechne extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named berechneEntfernung
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\BerechneEntfernungAnfrage $berechneEntfernungAnfrage
     * @return \StructType\BerechneEntfernungErgebnis|bool
     */
    public function berechneEntfernung(\StructType\BerechneEntfernungAnfrage $berechneEntfernungAnfrage)
    {
        try {
            $this->setResult($this->getSoapClient()->berechneEntfernung($berechneEntfernungAnfrage));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\BerechneEntfernungErgebnis
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
