<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeliveryDataRetrievalResponse StructType
 * @subpackage Structs
 */
class DeliveryDataRetrievalResponse extends AbstractStructBase
{
    /**
     * The Filing
     * Meta information extracted from the WSDL
     * - documentation: Elementti sisltää lähetetyn aineiston nimen.
     * - minOccurs: 0
     * @var string
     */
    public $Filing;
    /**
     * The Timestamp
     * Meta information extracted from the WSDL
     * - documentation: Elementin sisällä on noudon aikaleiman. Esim. 2018-10-13T11:05:15.522+03:00
     * @var string
     */
    public $Timestamp;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - documentation: Elementissä kerrotaan onko noutopyyntö onnistunut (Ok), aineisto tai tarkastustulos ole ei vielä noudettavissa (Wait) tai epäonnistunut (Error).
     * @var string
     */
    public $Status;
    /**
     * The Information
     * Meta information extracted from the WSDL
     * - documentation: Elementti sislätää esim. tiedon 'Aineisto ei vielä noudettavissa' tai 'Tuntematon noutotunniste'.
     * - minOccurs: 0
     * @var string
     */
    public $Information;
    /**
     * The RetrievalId
     * Meta information extracted from the WSDL
     * - documentation: Elementti kertoo käytetyn ilmoitusaineiston noutotunnisteen.
     * - minOccurs: 0
     * @var string
     */
    public $RetrievalId;
    /**
     * The ResultId
     * Meta information extracted from the WSDL
     * - documentation: Elementti kertoo käytetyn taustakäsittelyyn jätetyn ilmoitusaineiston tarkastustuloksen tulostunnisteen.
     * - minOccurs: 0
     * @var string
     */
    public $ResultId;
    /**
     * The Result
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Result
     */
    public $Result;
    /**
     * The DeliveryData
     * Meta information extracted from the WSDL
     * - documentation: Elementin sisällä on lähetyserässä olleet ilmoitukset täydennettynä Verohallinnon vastaustiedoilla tai taustakäsittelyyn jätetyn aineiston tarkastustuloksen MTOM/XOP-liitetiedostona.
     * - expectedContentTypes: application/octet-stream
     * - minOccurs: 0
     * @var string
     */
    public $DeliveryData;
    /**
     * Constructor method for DeliveryDataRetrievalResponse
     * @uses DeliveryDataRetrievalResponse::setFiling()
     * @uses DeliveryDataRetrievalResponse::setTimestamp()
     * @uses DeliveryDataRetrievalResponse::setStatus()
     * @uses DeliveryDataRetrievalResponse::setInformation()
     * @uses DeliveryDataRetrievalResponse::setRetrievalId()
     * @uses DeliveryDataRetrievalResponse::setResultId()
     * @uses DeliveryDataRetrievalResponse::setResult()
     * @uses DeliveryDataRetrievalResponse::setDeliveryData()
     * @param string $filing
     * @param string $timestamp
     * @param string $status
     * @param string $information
     * @param string $retrievalId
     * @param string $resultId
     * @param \StructType\Result $result
     * @param string $deliveryData
     */
    public function __construct($filing = null, $timestamp = null, $status = null, $information = null, $retrievalId = null, $resultId = null, \StructType\Result $result = null, $deliveryData = null)
    {
        $this
            ->setFiling($filing)
            ->setTimestamp($timestamp)
            ->setStatus($status)
            ->setInformation($information)
            ->setRetrievalId($retrievalId)
            ->setResultId($resultId)
            ->setResult($result)
            ->setDeliveryData($deliveryData);
    }
    /**
     * Get Filing value
     * @return string|null
     */
    public function getFiling()
    {
        return $this->Filing;
    }
    /**
     * Set Filing value
     * @param string $filing
     * @return \StructType\DeliveryDataRetrievalResponse
     */
    public function setFiling($filing = null)
    {
        // validation for constraint: string
        if (!is_null($filing) && !is_string($filing)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($filing, true), gettype($filing)), __LINE__);
        }
        $this->Filing = $filing;
        return $this;
    }
    /**
     * Get Timestamp value
     * @return string|null
     */
    public function getTimestamp()
    {
        return $this->Timestamp;
    }
    /**
     * Set Timestamp value
     * @param string $timestamp
     * @return \StructType\DeliveryDataRetrievalResponse
     */
    public function setTimestamp($timestamp = null)
    {
        // validation for constraint: string
        if (!is_null($timestamp) && !is_string($timestamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timestamp, true), gettype($timestamp)), __LINE__);
        }
        $this->Timestamp = $timestamp;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \EnumType\StatusType::valueIsValid()
     * @uses \EnumType\StatusType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\DeliveryDataRetrievalResponse
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\StatusType::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\StatusType', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \EnumType\StatusType::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get Information value
     * @return string|null
     */
    public function getInformation()
    {
        return $this->Information;
    }
    /**
     * Set Information value
     * @param string $information
     * @return \StructType\DeliveryDataRetrievalResponse
     */
    public function setInformation($information = null)
    {
        // validation for constraint: string
        if (!is_null($information) && !is_string($information)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($information, true), gettype($information)), __LINE__);
        }
        $this->Information = $information;
        return $this;
    }
    /**
     * Get RetrievalId value
     * @return string|null
     */
    public function getRetrievalId()
    {
        return $this->RetrievalId;
    }
    /**
     * Set RetrievalId value
     * @param string $retrievalId
     * @return \StructType\DeliveryDataRetrievalResponse
     */
    public function setRetrievalId($retrievalId = null)
    {
        // validation for constraint: string
        if (!is_null($retrievalId) && !is_string($retrievalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($retrievalId, true), gettype($retrievalId)), __LINE__);
        }
        $this->RetrievalId = $retrievalId;
        return $this;
    }
    /**
     * Get ResultId value
     * @return string|null
     */
    public function getResultId()
    {
        return $this->ResultId;
    }
    /**
     * Set ResultId value
     * @param string $resultId
     * @return \StructType\DeliveryDataRetrievalResponse
     */
    public function setResultId($resultId = null)
    {
        // validation for constraint: string
        if (!is_null($resultId) && !is_string($resultId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resultId, true), gettype($resultId)), __LINE__);
        }
        $this->ResultId = $resultId;
        return $this;
    }
    /**
     * Get Result value
     * @return \StructType\Result|null
     */
    public function getResult()
    {
        return $this->Result;
    }
    /**
     * Set Result value
     * @param \StructType\Result $result
     * @return \StructType\DeliveryDataRetrievalResponse
     */
    public function setResult(\StructType\Result $result = null)
    {
        $this->Result = $result;
        return $this;
    }
    /**
     * Get DeliveryData value
     * @return string|null
     */
    public function getDeliveryData()
    {
        return $this->DeliveryData;
    }
    /**
     * Set DeliveryData value
     * @param string $deliveryData
     * @return \StructType\DeliveryDataRetrievalResponse
     */
    public function setDeliveryData($deliveryData = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryData) && !is_string($deliveryData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryData, true), gettype($deliveryData)), __LINE__);
        }
        $this->DeliveryData = $deliveryData;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DeliveryDataRetrievalResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
