<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeliveryDataRetrievalRequest StructType
 * @subpackage Structs
 */
class DeliveryDataRetrievalRequest extends AbstractStructBase
{
    /**
     * The Language
     * Meta information extracted from the WSDL
     * - documentation: Vastaussanomassa käytettävä kieli (fi=suomi, sv=ruotsi, en=englanti).
     * - default: fi
     * @var string
     */
    public $Language;
    /**
     * The RetrievalId
     * Meta information extracted from the WSDL
     * - documentation: Elementin sisällä lähetetään kyselyä lähetettäessä saatu noutotunniste.
     * - minOccurs: 0
     * @var string
     */
    public $RetrievalId;
    /**
     * The ResultId
     * Meta information extracted from the WSDL
     * - documentation: Elementin sisällä lähetetään kyselyä lähetettäessä saatu tulostunniste taustakäsittelyyn jätetyn aineiston tarkastustuloksesta.
     * - minOccurs: 0
     * @var string
     */
    public $ResultId;
    /**
     * Constructor method for DeliveryDataRetrievalRequest
     * @uses DeliveryDataRetrievalRequest::setLanguage()
     * @uses DeliveryDataRetrievalRequest::setRetrievalId()
     * @uses DeliveryDataRetrievalRequest::setResultId()
     * @param string $language
     * @param string $retrievalId
     * @param string $resultId
     */
    public function __construct($language = 'fi', $retrievalId = null, $resultId = null)
    {
        $this
            ->setLanguage($language)
            ->setRetrievalId($retrievalId)
            ->setResultId($resultId);
    }
    /**
     * Get Language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->Language;
    }
    /**
     * Set Language value
     * @uses \EnumType\LanguageType::valueIsValid()
     * @uses \EnumType\LanguageType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $language
     * @return \StructType\DeliveryDataRetrievalRequest
     */
    public function setLanguage($language = 'fi')
    {
        // validation for constraint: enumeration
        if (!\EnumType\LanguageType::valueIsValid($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\LanguageType', is_array($language) ? implode(', ', $language) : var_export($language, true), implode(', ', \EnumType\LanguageType::getValidValues())), __LINE__);
        }
        $this->Language = $language;
        return $this;
    }
    /**
     * Get RetrievalId value
     * @return string|null
     */
    public function getRetrievalId()
    {
        return $this->RetrievalId;
    }
    /**
     * Set RetrievalId value
     * @param string $retrievalId
     * @return \StructType\DeliveryDataRetrievalRequest
     */
    public function setRetrievalId($retrievalId = null)
    {
        // validation for constraint: string
        if (!is_null($retrievalId) && !is_string($retrievalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($retrievalId, true), gettype($retrievalId)), __LINE__);
        }
        $this->RetrievalId = $retrievalId;
        return $this;
    }
    /**
     * Get ResultId value
     * @return string|null
     */
    public function getResultId()
    {
        return $this->ResultId;
    }
    /**
     * Set ResultId value
     * @param string $resultId
     * @return \StructType\DeliveryDataRetrievalRequest
     */
    public function setResultId($resultId = null)
    {
        // validation for constraint: string
        if (!is_null($resultId) && !is_string($resultId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resultId, true), gettype($resultId)), __LINE__);
        }
        $this->ResultId = $resultId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DeliveryDataRetrievalRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
