<?php

namespace EnumType;

/**
 * This class stands for LanguageType EnumType
 * @subpackage Enumerations
 */
class LanguageType
{
    /**
     * Constant for value 'fi'
     * @return string 'fi'
     */
    const VALUE_FI = 'fi';
    /**
     * Constant for value 'sv'
     * @return string 'sv'
     */
    const VALUE_SV = 'sv';
    /**
     * Constant for value 'en'
     * @return string 'en'
     */
    const VALUE_EN = 'en';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_FI
     * @uses self::VALUE_SV
     * @uses self::VALUE_EN
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_FI,
            self::VALUE_SV,
            self::VALUE_EN,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
