<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Result StructType
 * Meta information extracted from the WSDL
 * - documentation: Taustakäsittelyyn jätetyn aineiston tarkastustuloksen tila. | Elementin sisälle on koottu tiedot lähetyserän vastaanoton onnistumisesta tai epäonnistumisesta.
 * @subpackage Structs
 */
class Result extends AbstractStructBase
{
    /**
     * The Filing
     * Meta information extracted from the WSDL
     * - documentation: Elementti sisltää lähetetyn aineiston nimen.
     * - minOccurs: 0
     * @var string
     */
    public $Filing;
    /**
     * The Accepted
     * Meta information extracted from the WSDL
     * - documentation: Elementissä kerrotaan onko ilmoitusten vastaanotto onnistunut (true) vai epäonnistunut (false).
     * - default: false
     * @var bool
     */
    public $Accepted;
    /**
     * The Timestamp
     * Meta information extracted from the WSDL
     * - documentation: Elementissä kerrotaan lähetyksen aikaleiman. Esim. 2018-10-13T11:05:15.522+02:00
     * @var string
     */
    public $Timestamp;
    /**
     * The Information
     * Meta information extracted from the WSDL
     * - documentation: Elementissä kerrotaan syy mahdolliseen ilmoitusten hylkäämiseen.
     * - minOccurs: 0
     * @var string
     */
    public $Information;
    /**
     * The CheckSum
     * Meta information extracted from the WSDL
     * - documentation: Elementti sisältää SHA1-tarkistussumman ilmoitusaineiston sisällöstä.
     * - minOccurs: 0
     * @var string
     */
    public $CheckSum;
    /**
     * The DeliveryId
     * Meta information extracted from the WSDL
     * - documentation: Elementissä on sisältöä vain jos on lähetetty rakentamisen tiedonantomenettelyyn (Raksi) liittyviä perusilmoituksia. Tällöin elementin sisältönä on perusilmoituksen yksilöivä ilmoitustunniste.
     * - minOccurs: 0
     * @var string
     */
    public $DeliveryId;
    /**
     * The RetrievalId
     * Meta information extracted from the WSDL
     * - documentation: Elementti sisältää tunnisteen, jolla vastausaineisto voidaan noutaa.
     * - minOccurs: 0
     * @var string
     */
    public $RetrievalId;
    /**
     * The ResultId
     * Meta information extracted from the WSDL
     * - documentation: Elementti sisältää taustakäsittelyyn jätetyn ilmoitusaineiston tarkastustuloksen noutotunnisteen.
     * - minOccurs: 0
     * @var string
     */
    public $ResultId;
    /**
     * The Attachments
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Attachments
     */
    public $Attachments;
    /**
     * Constructor method for Result
     * @uses Result::setFiling()
     * @uses Result::setAccepted()
     * @uses Result::setTimestamp()
     * @uses Result::setInformation()
     * @uses Result::setCheckSum()
     * @uses Result::setDeliveryId()
     * @uses Result::setRetrievalId()
     * @uses Result::setResultId()
     * @uses Result::setAttachments()
     * @param string $filing
     * @param bool $accepted
     * @param string $timestamp
     * @param string $information
     * @param string $checkSum
     * @param string $deliveryId
     * @param string $retrievalId
     * @param string $resultId
     * @param \StructType\Attachments $attachments
     */
    public function __construct($filing = null, $accepted = false, $timestamp = null, $information = null, $checkSum = null, $deliveryId = null, $retrievalId = null, $resultId = null, \StructType\Attachments $attachments = null)
    {
        $this
            ->setFiling($filing)
            ->setAccepted($accepted)
            ->setTimestamp($timestamp)
            ->setInformation($information)
            ->setCheckSum($checkSum)
            ->setDeliveryId($deliveryId)
            ->setRetrievalId($retrievalId)
            ->setResultId($resultId)
            ->setAttachments($attachments);
    }
    /**
     * Get Filing value
     * @return string|null
     */
    public function getFiling()
    {
        return $this->Filing;
    }
    /**
     * Set Filing value
     * @param string $filing
     * @return \StructType\Result
     */
    public function setFiling($filing = null)
    {
        // validation for constraint: string
        if (!is_null($filing) && !is_string($filing)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($filing, true), gettype($filing)), __LINE__);
        }
        $this->Filing = $filing;
        return $this;
    }
    /**
     * Get Accepted value
     * @return bool|null
     */
    public function getAccepted()
    {
        return $this->Accepted;
    }
    /**
     * Set Accepted value
     * @param bool $accepted
     * @return \StructType\Result
     */
    public function setAccepted($accepted = false)
    {
        // validation for constraint: boolean
        if (!is_null($accepted) && !is_bool($accepted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($accepted, true), gettype($accepted)), __LINE__);
        }
        $this->Accepted = $accepted;
        return $this;
    }
    /**
     * Get Timestamp value
     * @return string|null
     */
    public function getTimestamp()
    {
        return $this->Timestamp;
    }
    /**
     * Set Timestamp value
     * @param string $timestamp
     * @return \StructType\Result
     */
    public function setTimestamp($timestamp = null)
    {
        // validation for constraint: string
        if (!is_null($timestamp) && !is_string($timestamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timestamp, true), gettype($timestamp)), __LINE__);
        }
        $this->Timestamp = $timestamp;
        return $this;
    }
    /**
     * Get Information value
     * @return string|null
     */
    public function getInformation()
    {
        return $this->Information;
    }
    /**
     * Set Information value
     * @param string $information
     * @return \StructType\Result
     */
    public function setInformation($information = null)
    {
        // validation for constraint: string
        if (!is_null($information) && !is_string($information)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($information, true), gettype($information)), __LINE__);
        }
        $this->Information = $information;
        return $this;
    }
    /**
     * Get CheckSum value
     * @return string|null
     */
    public function getCheckSum()
    {
        return $this->CheckSum;
    }
    /**
     * Set CheckSum value
     * @param string $checkSum
     * @return \StructType\Result
     */
    public function setCheckSum($checkSum = null)
    {
        // validation for constraint: string
        if (!is_null($checkSum) && !is_string($checkSum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($checkSum, true), gettype($checkSum)), __LINE__);
        }
        $this->CheckSum = $checkSum;
        return $this;
    }
    /**
     * Get DeliveryId value
     * @return string|null
     */
    public function getDeliveryId()
    {
        return $this->DeliveryId;
    }
    /**
     * Set DeliveryId value
     * @param string $deliveryId
     * @return \StructType\Result
     */
    public function setDeliveryId($deliveryId = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryId) && !is_string($deliveryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryId, true), gettype($deliveryId)), __LINE__);
        }
        $this->DeliveryId = $deliveryId;
        return $this;
    }
    /**
     * Get RetrievalId value
     * @return string|null
     */
    public function getRetrievalId()
    {
        return $this->RetrievalId;
    }
    /**
     * Set RetrievalId value
     * @param string $retrievalId
     * @return \StructType\Result
     */
    public function setRetrievalId($retrievalId = null)
    {
        // validation for constraint: string
        if (!is_null($retrievalId) && !is_string($retrievalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($retrievalId, true), gettype($retrievalId)), __LINE__);
        }
        $this->RetrievalId = $retrievalId;
        return $this;
    }
    /**
     * Get ResultId value
     * @return string|null
     */
    public function getResultId()
    {
        return $this->ResultId;
    }
    /**
     * Set ResultId value
     * @param string $resultId
     * @return \StructType\Result
     */
    public function setResultId($resultId = null)
    {
        // validation for constraint: string
        if (!is_null($resultId) && !is_string($resultId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resultId, true), gettype($resultId)), __LINE__);
        }
        $this->ResultId = $resultId;
        return $this;
    }
    /**
     * Get Attachments value
     * @return \StructType\Attachments|null
     */
    public function getAttachments()
    {
        return $this->Attachments;
    }
    /**
     * Set Attachments value
     * @param \StructType\Attachments $attachments
     * @return \StructType\Result
     */
    public function setAttachments(\StructType\Attachments $attachments = null)
    {
        $this->Attachments = $attachments;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Result
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
