<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeliveryDataSendRequest StructType
 * @subpackage Structs
 */
class DeliveryDataSendRequest extends AbstractStructBase
{
    /**
     * The Language
     * Meta information extracted from the WSDL
     * - documentation: Vastaussanomassa käytettävä kieli (fi=suomi, sv=ruotsi, en=englanti).
     * - default: fi
     * @var string
     */
    public $Language;
    /**
     * The BackgroundProcessing
     * Meta information extracted from the WSDL
     * - documentation: Aineiston taustakäsittely (false=normaali käsittely, true=taustakäsittely). Jos ei annettu suoritetaan normaali käsittely.
     * - default: false
     * - minOccurs: 0
     * @var bool
     */
    public $BackgroundProcessing;
    /**
     * The Emails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Emails
     */
    public $Emails;
    /**
     * The ReportingMaterial
     * Meta information extracted from the WSDL
     * - documentation: Elementti sisältää varsinainen ilmoituksen MTOM/XOP-liitteenä. Alkuperäisen tiedoston nimen on oltava mukana elementin sisällä.
     * - expectedContentTypes: application/octet-stream
     * - minOccurs: 0
     * @var string
     */
    public $ReportingMaterial;
    /**
     * The Attachments
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Attachments
     */
    public $Attachments;
    /**
     * Constructor method for DeliveryDataSendRequest
     * @uses DeliveryDataSendRequest::setLanguage()
     * @uses DeliveryDataSendRequest::setBackgroundProcessing()
     * @uses DeliveryDataSendRequest::setEmails()
     * @uses DeliveryDataSendRequest::setReportingMaterial()
     * @uses DeliveryDataSendRequest::setAttachments()
     * @param string $language
     * @param bool $backgroundProcessing
     * @param \StructType\Emails $emails
     * @param string $reportingMaterial
     * @param \StructType\Attachments $attachments
     */
    public function __construct($language = 'fi', $backgroundProcessing = false, \StructType\Emails $emails = null, $reportingMaterial = null, \StructType\Attachments $attachments = null)
    {
        $this
            ->setLanguage($language)
            ->setBackgroundProcessing($backgroundProcessing)
            ->setEmails($emails)
            ->setReportingMaterial($reportingMaterial)
            ->setAttachments($attachments);
    }
    /**
     * Get Language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->Language;
    }
    /**
     * Set Language value
     * @uses \EnumType\LanguageType::valueIsValid()
     * @uses \EnumType\LanguageType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $language
     * @return \StructType\DeliveryDataSendRequest
     */
    public function setLanguage($language = 'fi')
    {
        // validation for constraint: enumeration
        if (!\EnumType\LanguageType::valueIsValid($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\LanguageType', is_array($language) ? implode(', ', $language) : var_export($language, true), implode(', ', \EnumType\LanguageType::getValidValues())), __LINE__);
        }
        $this->Language = $language;
        return $this;
    }
    /**
     * Get BackgroundProcessing value
     * @return bool|null
     */
    public function getBackgroundProcessing()
    {
        return $this->BackgroundProcessing;
    }
    /**
     * Set BackgroundProcessing value
     * @param bool $backgroundProcessing
     * @return \StructType\DeliveryDataSendRequest
     */
    public function setBackgroundProcessing($backgroundProcessing = false)
    {
        // validation for constraint: boolean
        if (!is_null($backgroundProcessing) && !is_bool($backgroundProcessing)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($backgroundProcessing, true), gettype($backgroundProcessing)), __LINE__);
        }
        $this->BackgroundProcessing = $backgroundProcessing;
        return $this;
    }
    /**
     * Get Emails value
     * @return \StructType\Emails|null
     */
    public function getEmails()
    {
        return $this->Emails;
    }
    /**
     * Set Emails value
     * @param \StructType\Emails $emails
     * @return \StructType\DeliveryDataSendRequest
     */
    public function setEmails(\StructType\Emails $emails = null)
    {
        $this->Emails = $emails;
        return $this;
    }
    /**
     * Get ReportingMaterial value
     * @return string|null
     */
    public function getReportingMaterial()
    {
        return $this->ReportingMaterial;
    }
    /**
     * Set ReportingMaterial value
     * @param string $reportingMaterial
     * @return \StructType\DeliveryDataSendRequest
     */
    public function setReportingMaterial($reportingMaterial = null)
    {
        // validation for constraint: string
        if (!is_null($reportingMaterial) && !is_string($reportingMaterial)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reportingMaterial, true), gettype($reportingMaterial)), __LINE__);
        }
        $this->ReportingMaterial = $reportingMaterial;
        return $this;
    }
    /**
     * Get Attachments value
     * @return \StructType\Attachments|null
     */
    public function getAttachments()
    {
        return $this->Attachments;
    }
    /**
     * Set Attachments value
     * @param \StructType\Attachments $attachments
     * @return \StructType\DeliveryDataSendRequest
     */
    public function setAttachments(\StructType\Attachments $attachments = null)
    {
        $this->Attachments = $attachments;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DeliveryDataSendRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
