<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Attachment StructType
 * Meta information extracted from the WSDL
 * - documentation: Elementti sisältää tiedot lähetetystä tuloveroliitetiedostosta.
 * @subpackage Structs
 */
class Attachment extends AbstractStructBase
{
    /**
     * The FileName
     * Meta information extracted from the WSDL
     * - documentation: Elementti kertoo lähetetyn liitetiedoston nimen.
     * @var string
     */
    public $FileName;
    /**
     * The Accepted
     * Meta information extracted from the WSDL
     * - documentation: Elementti kertoo onko tiedosto otettu vastaan (true) vai hylätty (false).
     * @var bool
     */
    public $Accepted;
    /**
     * The Information
     * Meta information extracted from the WSDL
     * - documentation: Elementti kertoo syyn liitteen hylkäämiseen.
     * - minOccurs: 0
     * @var string
     */
    public $Information;
    /**
     * Constructor method for Attachment
     * @uses Attachment::setFileName()
     * @uses Attachment::setAccepted()
     * @uses Attachment::setInformation()
     * @param string $fileName
     * @param bool $accepted
     * @param string $information
     */
    public function __construct($fileName = null, $accepted = null, $information = null)
    {
        $this
            ->setFileName($fileName)
            ->setAccepted($accepted)
            ->setInformation($information);
    }
    /**
     * Get FileName value
     * @return string|null
     */
    public function getFileName()
    {
        return $this->FileName;
    }
    /**
     * Set FileName value
     * @param string $fileName
     * @return \StructType\Attachment
     */
    public function setFileName($fileName = null)
    {
        // validation for constraint: string
        if (!is_null($fileName) && !is_string($fileName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fileName, true), gettype($fileName)), __LINE__);
        }
        $this->FileName = $fileName;
        return $this;
    }
    /**
     * Get Accepted value
     * @return bool|null
     */
    public function getAccepted()
    {
        return $this->Accepted;
    }
    /**
     * Set Accepted value
     * @param bool $accepted
     * @return \StructType\Attachment
     */
    public function setAccepted($accepted = null)
    {
        // validation for constraint: boolean
        if (!is_null($accepted) && !is_bool($accepted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($accepted, true), gettype($accepted)), __LINE__);
        }
        $this->Accepted = $accepted;
        return $this;
    }
    /**
     * Get Information value
     * @return string|null
     */
    public function getInformation()
    {
        return $this->Information;
    }
    /**
     * Set Information value
     * @param string $information
     * @return \StructType\Attachment
     */
    public function setInformation($information = null)
    {
        // validation for constraint: string
        if (!is_null($information) && !is_string($information)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($information, true), gettype($information)), __LINE__);
        }
        $this->Information = $information;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Attachment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
