<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Attachments StructType
 * Meta information extracted from the WSDL
 * - documentation: Elementti sisältää tiedot lähetetyistä liitetiedostoista. | Elementti sisältää ilmoituksen tuloveroliitetiedostot.
 * @subpackage Structs
 */
class Attachments extends AbstractStructBase
{
    /**
     * The Attachment
     * Meta information extracted from the WSDL
     * - documentation: Elementti sisältää tuloveroliitetiedoston MTOM/XOP-liitteenä. Alkuperäisen tiedoston nimen on oltava mukana elementin sisällä.
     * - expectedContentTypes: application/octet-stream
     * - maxOccurs: 16
     * - minOccurs: 0
     * @var string[]
     */
    public $Attachment;
    /**
     * Constructor method for Attachments
     * @uses Attachments::setAttachment()
     * @param string[] $attachment
     */
    public function __construct(array $attachment = array())
    {
        $this
            ->setAttachment($attachment);
    }
    /**
     * Get Attachment value
     * @return string[]|null
     */
    public function getAttachment()
    {
        return $this->Attachment;
    }
    /**
     * This method is responsible for validating the values passed to the setAttachment method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAttachment method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAttachmentForArrayConstraintsFromSetAttachment(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $attachmentsAttachmentItem) {
            // validation for constraint: itemType
            if (!is_string($attachmentsAttachmentItem)) {
                $invalidValues[] = is_object($attachmentsAttachmentItem) ? get_class($attachmentsAttachmentItem) : sprintf('%s(%s)', gettype($attachmentsAttachmentItem), var_export($attachmentsAttachmentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Attachment property can only contain items of type base64Binary, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Attachment value
     * @throws \InvalidArgumentException
     * @param string[] $attachment
     * @return \StructType\Attachments
     */
    public function setAttachment(array $attachment = array())
    {
        // validation for constraint: array
        if ('' !== ($attachmentArrayErrorMessage = self::validateAttachmentForArrayConstraintsFromSetAttachment($attachment))) {
            throw new \InvalidArgumentException($attachmentArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(16)
        if (is_array($attachment) && count($attachment) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 16', count($attachment)), __LINE__);
        }
        $this->Attachment = $attachment;
        return $this;
    }
    /**
     * Add item to Attachment value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\Attachments
     */
    public function addToAttachment($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The Attachment property can only contain items of type base64Binary, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(16)
        if (is_array($this->Attachment) && count($this->Attachment) >= 16) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 16', count($this->Attachment)), __LINE__);
        }
        $this->Attachment[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Attachments
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
