<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://5.26.72.150:8095/IntegrationWebService.asmx?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://5.26.72.150:8095/IntegrationWebService.asmx?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Test ServiceType
 */
$test = new \ServiceType\Test($options);
/**
 * Sample call for Test operation/method
 */
if ($test->Test(new \StructType\Test()) !== false) {
    print_r($test->getResult());
} else {
    print_r($test->getLastError());
}
/**
 * Samples for Integration ServiceType
 */
$integration = new \ServiceType\Integration($options);
/**
 * Sample call for IntegrationSendEntitySetWithLogin operation/method
 */
if ($integration->IntegrationSendEntitySetWithLogin(new \StructType\IntegrationSendEntitySetWithLogin()) !== false) {
    print_r($integration->getResult());
} else {
    print_r($integration->getLastError());
}
/**
 * Sample call for IntegrationSendCancelledEntitySetWithLogin operation/method
 */
if ($integration->IntegrationSendCancelledEntitySetWithLogin(new \StructType\IntegrationSendCancelledEntitySetWithLogin()) !== false) {
    print_r($integration->getResult());
} else {
    print_r($integration->getLastError());
}
/**
 * Sample call for IntegrationLogin operation/method
 */
if ($integration->IntegrationLogin(new \StructType\IntegrationLogin()) !== false) {
    print_r($integration->getResult());
} else {
    print_r($integration->getLastError());
}
/**
 * Sample call for IntegrationLogout operation/method
 */
if ($integration->IntegrationLogout(new \StructType\IntegrationLogout()) !== false) {
    print_r($integration->getResult());
} else {
    print_r($integration->getLastError());
}
/**
 * Sample call for IntegrationSendEntitySet operation/method
 */
if ($integration->IntegrationSendEntitySet(new \StructType\IntegrationSendEntitySet()) !== false) {
    print_r($integration->getResult());
} else {
    print_r($integration->getLastError());
}
/**
 * Sample call for IntegrationGetEntitySet operation/method
 */
if ($integration->IntegrationGetEntitySet(new \StructType\IntegrationGetEntitySet()) !== false) {
    print_r($integration->getResult());
} else {
    print_r($integration->getLastError());
}
/**
 * Sample call for IntegrationGetEntitySetWithLogin operation/method
 */
if ($integration->IntegrationGetEntitySetWithLogin(new \StructType\IntegrationGetEntitySetWithLogin()) !== false) {
    print_r($integration->getResult());
} else {
    print_r($integration->getLastError());
}
/**
 * Sample call for IntegrationGetEntitySetWithPacketLogin operation/method
 */
if ($integration->IntegrationGetEntitySetWithPacketLogin(new \StructType\IntegrationGetEntitySetWithPacketLogin()) !== false) {
    print_r($integration->getResult());
} else {
    print_r($integration->getLastError());
}
/**
 * Sample call for IntegrationSendSuccessResult operation/method
 */
if ($integration->IntegrationSendSuccessResult(new \StructType\IntegrationSendSuccessResult()) !== false) {
    print_r($integration->getResult());
} else {
    print_r($integration->getLastError());
}
/**
 * Sample call for IntegrationDeleteTransferStatus operation/method
 */
if ($integration->IntegrationDeleteTransferStatus(new \StructType\IntegrationDeleteTransferStatus()) !== false) {
    print_r($integration->getResult());
} else {
    print_r($integration->getLastError());
}
/**
 * Sample call for IntegrationSendUpdateRecord operation/method
 */
if ($integration->IntegrationSendUpdateRecord(new \StructType\IntegrationSendUpdateRecord()) !== false) {
    print_r($integration->getResult());
} else {
    print_r($integration->getLastError());
}
/**
 * Sample call for IntegrationSendUpdateRecordWithCode operation/method
 */
if ($integration->IntegrationSendUpdateRecordWithCode(new \StructType\IntegrationSendUpdateRecordWithCode()) !== false) {
    print_r($integration->getResult());
} else {
    print_r($integration->getLastError());
}
/**
 * Sample call for IntegrationSendCollectionPaid operation/method
 */
if ($integration->IntegrationSendCollectionPaid(new \StructType\IntegrationSendCollectionPaid()) !== false) {
    print_r($integration->getResult());
} else {
    print_r($integration->getLastError());
}
/**
 * Samples for Logout ServiceType
 */
$logout = new \ServiceType\Logout($options);
/**
 * Sample call for Logout operation/method
 */
if ($logout->Logout(new \StructType\Logout()) !== false) {
    print_r($logout->getResult());
} else {
    print_r($logout->getLastError());
}
