<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for clsTercihliUrunBaslik StructType
 * @subpackage Structs
 */
class ClsTercihliUrunBaslik extends ClsSharedTercihliUrunBaslik
{
    /**
     * The Ilkislemtarihi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Ilkislemtarihi;
    /**
     * The Ilkkullanicikod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Ilkkullanicikod;
    /**
     * The Sonislemtarihi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Sonislemtarihi;
    /**
     * The Sonkullanicikod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Sonkullanicikod;
    /**
     * Constructor method for clsTercihliUrunBaslik
     * @uses ClsTercihliUrunBaslik::setIlkislemtarihi()
     * @uses ClsTercihliUrunBaslik::setIlkkullanicikod()
     * @uses ClsTercihliUrunBaslik::setSonislemtarihi()
     * @uses ClsTercihliUrunBaslik::setSonkullanicikod()
     * @param string $ilkislemtarihi
     * @param int $ilkkullanicikod
     * @param string $sonislemtarihi
     * @param int $sonkullanicikod
     */
    public function __construct($ilkislemtarihi = null, $ilkkullanicikod = null, $sonislemtarihi = null, $sonkullanicikod = null)
    {
        $this
            ->setIlkislemtarihi($ilkislemtarihi)
            ->setIlkkullanicikod($ilkkullanicikod)
            ->setSonislemtarihi($sonislemtarihi)
            ->setSonkullanicikod($sonkullanicikod);
    }
    /**
     * Get Ilkislemtarihi value
     * @return string
     */
    public function getIlkislemtarihi()
    {
        return $this->Ilkislemtarihi;
    }
    /**
     * Set Ilkislemtarihi value
     * @param string $ilkislemtarihi
     * @return \StructType\ClsTercihliUrunBaslik
     */
    public function setIlkislemtarihi($ilkislemtarihi = null)
    {
        // validation for constraint: string
        if (!is_null($ilkislemtarihi) && !is_string($ilkislemtarihi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ilkislemtarihi, true), gettype($ilkislemtarihi)), __LINE__);
        }
        $this->Ilkislemtarihi = $ilkislemtarihi;
        return $this;
    }
    /**
     * Get Ilkkullanicikod value
     * @return int
     */
    public function getIlkkullanicikod()
    {
        return $this->Ilkkullanicikod;
    }
    /**
     * Set Ilkkullanicikod value
     * @param int $ilkkullanicikod
     * @return \StructType\ClsTercihliUrunBaslik
     */
    public function setIlkkullanicikod($ilkkullanicikod = null)
    {
        // validation for constraint: int
        if (!is_null($ilkkullanicikod) && !(is_int($ilkkullanicikod) || ctype_digit($ilkkullanicikod))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ilkkullanicikod, true), gettype($ilkkullanicikod)), __LINE__);
        }
        $this->Ilkkullanicikod = $ilkkullanicikod;
        return $this;
    }
    /**
     * Get Sonislemtarihi value
     * @return string
     */
    public function getSonislemtarihi()
    {
        return $this->Sonislemtarihi;
    }
    /**
     * Set Sonislemtarihi value
     * @param string $sonislemtarihi
     * @return \StructType\ClsTercihliUrunBaslik
     */
    public function setSonislemtarihi($sonislemtarihi = null)
    {
        // validation for constraint: string
        if (!is_null($sonislemtarihi) && !is_string($sonislemtarihi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sonislemtarihi, true), gettype($sonislemtarihi)), __LINE__);
        }
        $this->Sonislemtarihi = $sonislemtarihi;
        return $this;
    }
    /**
     * Get Sonkullanicikod value
     * @return int
     */
    public function getSonkullanicikod()
    {
        return $this->Sonkullanicikod;
    }
    /**
     * Set Sonkullanicikod value
     * @param int $sonkullanicikod
     * @return \StructType\ClsTercihliUrunBaslik
     */
    public function setSonkullanicikod($sonkullanicikod = null)
    {
        // validation for constraint: int
        if (!is_null($sonkullanicikod) && !(is_int($sonkullanicikod) || ctype_digit($sonkullanicikod))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sonkullanicikod, true), gettype($sonkullanicikod)), __LINE__);
        }
        $this->Sonkullanicikod = $sonkullanicikod;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ClsTercihliUrunBaslik
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
