<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for clsSharedPalye StructType
 * @subpackage Structs
 */
class ClsSharedPalye extends ClsEntity
{
    /**
     * The PalyeKod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $PalyeKod;
    /**
     * The UrunRef
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $UrunRef;
    /**
     * The Sira
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Sira;
    /**
     * The BirimSira
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $BirimSira;
    /**
     * The Miktar
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Miktar;
    /**
     * Constructor method for clsSharedPalye
     * @uses ClsSharedPalye::setPalyeKod()
     * @uses ClsSharedPalye::setUrunRef()
     * @uses ClsSharedPalye::setSira()
     * @uses ClsSharedPalye::setBirimSira()
     * @uses ClsSharedPalye::setMiktar()
     * @param int $palyeKod
     * @param int $urunRef
     * @param int $sira
     * @param string $birimSira
     * @param float $miktar
     */
    public function __construct($palyeKod = null, $urunRef = null, $sira = null, $birimSira = null, $miktar = null)
    {
        $this
            ->setPalyeKod($palyeKod)
            ->setUrunRef($urunRef)
            ->setSira($sira)
            ->setBirimSira($birimSira)
            ->setMiktar($miktar);
    }
    /**
     * Get PalyeKod value
     * @return int
     */
    public function getPalyeKod()
    {
        return $this->PalyeKod;
    }
    /**
     * Set PalyeKod value
     * @param int $palyeKod
     * @return \StructType\ClsSharedPalye
     */
    public function setPalyeKod($palyeKod = null)
    {
        // validation for constraint: int
        if (!is_null($palyeKod) && !(is_int($palyeKod) || ctype_digit($palyeKod))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($palyeKod, true), gettype($palyeKod)), __LINE__);
        }
        $this->PalyeKod = $palyeKod;
        return $this;
    }
    /**
     * Get UrunRef value
     * @return int
     */
    public function getUrunRef()
    {
        return $this->UrunRef;
    }
    /**
     * Set UrunRef value
     * @param int $urunRef
     * @return \StructType\ClsSharedPalye
     */
    public function setUrunRef($urunRef = null)
    {
        // validation for constraint: int
        if (!is_null($urunRef) && !(is_int($urunRef) || ctype_digit($urunRef))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($urunRef, true), gettype($urunRef)), __LINE__);
        }
        $this->UrunRef = $urunRef;
        return $this;
    }
    /**
     * Get Sira value
     * @return int
     */
    public function getSira()
    {
        return $this->Sira;
    }
    /**
     * Set Sira value
     * @param int $sira
     * @return \StructType\ClsSharedPalye
     */
    public function setSira($sira = null)
    {
        // validation for constraint: int
        if (!is_null($sira) && !(is_int($sira) || ctype_digit($sira))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sira, true), gettype($sira)), __LINE__);
        }
        $this->Sira = $sira;
        return $this;
    }
    /**
     * Get BirimSira value
     * @return string
     */
    public function getBirimSira()
    {
        return $this->BirimSira;
    }
    /**
     * Set BirimSira value
     * @param string $birimSira
     * @return \StructType\ClsSharedPalye
     */
    public function setBirimSira($birimSira = null)
    {
        // validation for constraint: string
        if (!is_null($birimSira) && !is_string($birimSira)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($birimSira, true), gettype($birimSira)), __LINE__);
        }
        $this->BirimSira = $birimSira;
        return $this;
    }
    /**
     * Get Miktar value
     * @return float
     */
    public function getMiktar()
    {
        return $this->Miktar;
    }
    /**
     * Set Miktar value
     * @param float $miktar
     * @return \StructType\ClsSharedPalye
     */
    public function setMiktar($miktar = null)
    {
        // validation for constraint: float
        if (!is_null($miktar) && !(is_float($miktar) || is_numeric($miktar))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($miktar, true), gettype($miktar)), __LINE__);
        }
        $this->Miktar = $miktar;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ClsSharedPalye
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
