<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for clsSharedIadeNeden StructType
 * @subpackage Structs
 */
class ClsSharedIadeNeden extends ClsEntity
{
    /**
     * The Kod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Kod;
    /**
     * The IadeNedenTip
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $IadeNedenTip;
    /**
     * The Ad
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Ad;
    /**
     * Constructor method for clsSharedIadeNeden
     * @uses ClsSharedIadeNeden::setKod()
     * @uses ClsSharedIadeNeden::setIadeNedenTip()
     * @uses ClsSharedIadeNeden::setAd()
     * @param int $kod
     * @param string $iadeNedenTip
     * @param string $ad
     */
    public function __construct($kod = null, $iadeNedenTip = null, $ad = null)
    {
        $this
            ->setKod($kod)
            ->setIadeNedenTip($iadeNedenTip)
            ->setAd($ad);
    }
    /**
     * Get Kod value
     * @return int
     */
    public function getKod()
    {
        return $this->Kod;
    }
    /**
     * Set Kod value
     * @param int $kod
     * @return \StructType\ClsSharedIadeNeden
     */
    public function setKod($kod = null)
    {
        // validation for constraint: int
        if (!is_null($kod) && !(is_int($kod) || ctype_digit($kod))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($kod, true), gettype($kod)), __LINE__);
        }
        $this->Kod = $kod;
        return $this;
    }
    /**
     * Get IadeNedenTip value
     * @return string
     */
    public function getIadeNedenTip()
    {
        return $this->IadeNedenTip;
    }
    /**
     * Set IadeNedenTip value
     * @param string $iadeNedenTip
     * @return \StructType\ClsSharedIadeNeden
     */
    public function setIadeNedenTip($iadeNedenTip = null)
    {
        // validation for constraint: string
        if (!is_null($iadeNedenTip) && !is_string($iadeNedenTip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iadeNedenTip, true), gettype($iadeNedenTip)), __LINE__);
        }
        $this->IadeNedenTip = $iadeNedenTip;
        return $this;
    }
    /**
     * Get Ad value
     * @return string|null
     */
    public function getAd()
    {
        return $this->Ad;
    }
    /**
     * Set Ad value
     * @param string $ad
     * @return \StructType\ClsSharedIadeNeden
     */
    public function setAd($ad = null)
    {
        // validation for constraint: string
        if (!is_null($ad) && !is_string($ad)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ad, true), gettype($ad)), __LINE__);
        }
        $this->Ad = $ad;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ClsSharedIadeNeden
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
