<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for clsIadeNeden StructType
 * @subpackage Structs
 */
class ClsIadeNeden extends ClsSharedIadeNeden
{
    /**
     * The SonIslemTarihi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $SonIslemTarihi;
    /**
     * The Sonkullanicikod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Sonkullanicikod;
    /**
     * The Ilkislemtarihi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Ilkislemtarihi;
    /**
     * The Ilkkullanicikod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Ilkkullanicikod;
    /**
     * The DistKod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $DistKod;
    /**
     * The UygulamaYeri
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $UygulamaYeri;
    /**
     * The SonIslemHost
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SonIslemHost;
    /**
     * Constructor method for clsIadeNeden
     * @uses ClsIadeNeden::setSonIslemTarihi()
     * @uses ClsIadeNeden::setSonkullanicikod()
     * @uses ClsIadeNeden::setIlkislemtarihi()
     * @uses ClsIadeNeden::setIlkkullanicikod()
     * @uses ClsIadeNeden::setDistKod()
     * @uses ClsIadeNeden::setUygulamaYeri()
     * @uses ClsIadeNeden::setSonIslemHost()
     * @param string $sonIslemTarihi
     * @param int $sonkullanicikod
     * @param string $ilkislemtarihi
     * @param int $ilkkullanicikod
     * @param int $distKod
     * @param string $uygulamaYeri
     * @param string $sonIslemHost
     */
    public function __construct($sonIslemTarihi = null, $sonkullanicikod = null, $ilkislemtarihi = null, $ilkkullanicikod = null, $distKod = null, $uygulamaYeri = null, $sonIslemHost = null)
    {
        $this
            ->setSonIslemTarihi($sonIslemTarihi)
            ->setSonkullanicikod($sonkullanicikod)
            ->setIlkislemtarihi($ilkislemtarihi)
            ->setIlkkullanicikod($ilkkullanicikod)
            ->setDistKod($distKod)
            ->setUygulamaYeri($uygulamaYeri)
            ->setSonIslemHost($sonIslemHost);
    }
    /**
     * Get SonIslemTarihi value
     * @return string
     */
    public function getSonIslemTarihi()
    {
        return $this->SonIslemTarihi;
    }
    /**
     * Set SonIslemTarihi value
     * @param string $sonIslemTarihi
     * @return \StructType\ClsIadeNeden
     */
    public function setSonIslemTarihi($sonIslemTarihi = null)
    {
        // validation for constraint: string
        if (!is_null($sonIslemTarihi) && !is_string($sonIslemTarihi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sonIslemTarihi, true), gettype($sonIslemTarihi)), __LINE__);
        }
        $this->SonIslemTarihi = $sonIslemTarihi;
        return $this;
    }
    /**
     * Get Sonkullanicikod value
     * @return int
     */
    public function getSonkullanicikod()
    {
        return $this->Sonkullanicikod;
    }
    /**
     * Set Sonkullanicikod value
     * @param int $sonkullanicikod
     * @return \StructType\ClsIadeNeden
     */
    public function setSonkullanicikod($sonkullanicikod = null)
    {
        // validation for constraint: int
        if (!is_null($sonkullanicikod) && !(is_int($sonkullanicikod) || ctype_digit($sonkullanicikod))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sonkullanicikod, true), gettype($sonkullanicikod)), __LINE__);
        }
        $this->Sonkullanicikod = $sonkullanicikod;
        return $this;
    }
    /**
     * Get Ilkislemtarihi value
     * @return string
     */
    public function getIlkislemtarihi()
    {
        return $this->Ilkislemtarihi;
    }
    /**
     * Set Ilkislemtarihi value
     * @param string $ilkislemtarihi
     * @return \StructType\ClsIadeNeden
     */
    public function setIlkislemtarihi($ilkislemtarihi = null)
    {
        // validation for constraint: string
        if (!is_null($ilkislemtarihi) && !is_string($ilkislemtarihi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ilkislemtarihi, true), gettype($ilkislemtarihi)), __LINE__);
        }
        $this->Ilkislemtarihi = $ilkislemtarihi;
        return $this;
    }
    /**
     * Get Ilkkullanicikod value
     * @return int
     */
    public function getIlkkullanicikod()
    {
        return $this->Ilkkullanicikod;
    }
    /**
     * Set Ilkkullanicikod value
     * @param int $ilkkullanicikod
     * @return \StructType\ClsIadeNeden
     */
    public function setIlkkullanicikod($ilkkullanicikod = null)
    {
        // validation for constraint: int
        if (!is_null($ilkkullanicikod) && !(is_int($ilkkullanicikod) || ctype_digit($ilkkullanicikod))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ilkkullanicikod, true), gettype($ilkkullanicikod)), __LINE__);
        }
        $this->Ilkkullanicikod = $ilkkullanicikod;
        return $this;
    }
    /**
     * Get DistKod value
     * @return int
     */
    public function getDistKod()
    {
        return $this->DistKod;
    }
    /**
     * Set DistKod value
     * @param int $distKod
     * @return \StructType\ClsIadeNeden
     */
    public function setDistKod($distKod = null)
    {
        // validation for constraint: int
        if (!is_null($distKod) && !(is_int($distKod) || ctype_digit($distKod))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($distKod, true), gettype($distKod)), __LINE__);
        }
        $this->DistKod = $distKod;
        return $this;
    }
    /**
     * Get UygulamaYeri value
     * @return string
     */
    public function getUygulamaYeri()
    {
        return $this->UygulamaYeri;
    }
    /**
     * Set UygulamaYeri value
     * @param string $uygulamaYeri
     * @return \StructType\ClsIadeNeden
     */
    public function setUygulamaYeri($uygulamaYeri = null)
    {
        // validation for constraint: string
        if (!is_null($uygulamaYeri) && !is_string($uygulamaYeri)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uygulamaYeri, true), gettype($uygulamaYeri)), __LINE__);
        }
        $this->UygulamaYeri = $uygulamaYeri;
        return $this;
    }
    /**
     * Get SonIslemHost value
     * @return string|null
     */
    public function getSonIslemHost()
    {
        return $this->SonIslemHost;
    }
    /**
     * Set SonIslemHost value
     * @param string $sonIslemHost
     * @return \StructType\ClsIadeNeden
     */
    public function setSonIslemHost($sonIslemHost = null)
    {
        // validation for constraint: string
        if (!is_null($sonIslemHost) && !is_string($sonIslemHost)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sonIslemHost, true), gettype($sonIslemHost)), __LINE__);
        }
        $this->SonIslemHost = $sonIslemHost;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ClsIadeNeden
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
