<?php

namespace EnumType;

/**
 * This class stands for clsERAktivasyonTip EnumType
 * @subpackage Enumerations
 */
class ClsERAktivasyonTip
{
    /**
     * Constant for value 'AktiveOlmamis'
     * @return string 'AktiveOlmamis'
     */
    const VALUE_AKTIVE_OLMAMIS = 'AktiveOlmamis';
    /**
     * Constant for value 'AktiveOlmus'
     * @return string 'AktiveOlmus'
     */
    const VALUE_AKTIVE_OLMUS = 'AktiveOlmus';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_AKTIVE_OLMAMIS
     * @uses self::VALUE_AKTIVE_OLMUS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_AKTIVE_OLMAMIS,
            self::VALUE_AKTIVE_OLMUS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
