<?php

namespace EnumType;

/**
 * This class stands for clsERFiyatHesaplamaTip EnumType
 * @subpackage Enumerations
 */
class ClsERFiyatHesaplamaTip
{
    /**
     * Constant for value 'Uygulama'
     * @return string 'Uygulama'
     */
    const VALUE_UYGULAMA = 'Uygulama';
    /**
     * Constant for value 'Satis'
     * @return string 'Satis'
     */
    const VALUE_SATIS = 'Satis';
    /**
     * Constant for value 'Alis'
     * @return string 'Alis'
     */
    const VALUE_ALIS = 'Alis';
    /**
     * Constant for value 'BozukIade'
     * @return string 'BozukIade'
     */
    const VALUE_BOZUK_IADE = 'BozukIade';
    /**
     * Constant for value 'SaglamIade'
     * @return string 'SaglamIade'
     */
    const VALUE_SAGLAM_IADE = 'SaglamIade';
    /**
     * Constant for value 'TavsiyeFiyat'
     * @return string 'TavsiyeFiyat'
     */
    const VALUE_TAVSIYE_FIYAT = 'TavsiyeFiyat';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_UYGULAMA
     * @uses self::VALUE_SATIS
     * @uses self::VALUE_ALIS
     * @uses self::VALUE_BOZUK_IADE
     * @uses self::VALUE_SAGLAM_IADE
     * @uses self::VALUE_TAVSIYE_FIYAT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_UYGULAMA,
            self::VALUE_SATIS,
            self::VALUE_ALIS,
            self::VALUE_BOZUK_IADE,
            self::VALUE_SAGLAM_IADE,
            self::VALUE_TAVSIYE_FIYAT,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
