<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for clsSharedKarmaKoli StructType
 * @subpackage Structs
 */
class ClsSharedKarmaKoli extends ClsEntity
{
    /**
     * The KKUrunKod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $KKUrunKod;
    /**
     * The UrunRef
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $UrunRef;
    /**
     * The Sira
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Sira;
    /**
     * The BirimSira
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $BirimSira;
    /**
     * The Miktar
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Miktar;
    /**
     * The Fiyat
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Fiyat;
    /**
     * The AlisFiyat
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $AlisFiyat;
    /**
     * Constructor method for clsSharedKarmaKoli
     * @uses ClsSharedKarmaKoli::setKKUrunKod()
     * @uses ClsSharedKarmaKoli::setUrunRef()
     * @uses ClsSharedKarmaKoli::setSira()
     * @uses ClsSharedKarmaKoli::setBirimSira()
     * @uses ClsSharedKarmaKoli::setMiktar()
     * @uses ClsSharedKarmaKoli::setFiyat()
     * @uses ClsSharedKarmaKoli::setAlisFiyat()
     * @param int $kKUrunKod
     * @param int $urunRef
     * @param int $sira
     * @param string $birimSira
     * @param float $miktar
     * @param float $fiyat
     * @param float $alisFiyat
     */
    public function __construct($kKUrunKod = null, $urunRef = null, $sira = null, $birimSira = null, $miktar = null, $fiyat = null, $alisFiyat = null)
    {
        $this
            ->setKKUrunKod($kKUrunKod)
            ->setUrunRef($urunRef)
            ->setSira($sira)
            ->setBirimSira($birimSira)
            ->setMiktar($miktar)
            ->setFiyat($fiyat)
            ->setAlisFiyat($alisFiyat);
    }
    /**
     * Get KKUrunKod value
     * @return int
     */
    public function getKKUrunKod()
    {
        return $this->KKUrunKod;
    }
    /**
     * Set KKUrunKod value
     * @param int $kKUrunKod
     * @return \StructType\ClsSharedKarmaKoli
     */
    public function setKKUrunKod($kKUrunKod = null)
    {
        // validation for constraint: int
        if (!is_null($kKUrunKod) && !(is_int($kKUrunKod) || ctype_digit($kKUrunKod))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($kKUrunKod, true), gettype($kKUrunKod)), __LINE__);
        }
        $this->KKUrunKod = $kKUrunKod;
        return $this;
    }
    /**
     * Get UrunRef value
     * @return int
     */
    public function getUrunRef()
    {
        return $this->UrunRef;
    }
    /**
     * Set UrunRef value
     * @param int $urunRef
     * @return \StructType\ClsSharedKarmaKoli
     */
    public function setUrunRef($urunRef = null)
    {
        // validation for constraint: int
        if (!is_null($urunRef) && !(is_int($urunRef) || ctype_digit($urunRef))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($urunRef, true), gettype($urunRef)), __LINE__);
        }
        $this->UrunRef = $urunRef;
        return $this;
    }
    /**
     * Get Sira value
     * @return int
     */
    public function getSira()
    {
        return $this->Sira;
    }
    /**
     * Set Sira value
     * @param int $sira
     * @return \StructType\ClsSharedKarmaKoli
     */
    public function setSira($sira = null)
    {
        // validation for constraint: int
        if (!is_null($sira) && !(is_int($sira) || ctype_digit($sira))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sira, true), gettype($sira)), __LINE__);
        }
        $this->Sira = $sira;
        return $this;
    }
    /**
     * Get BirimSira value
     * @return string
     */
    public function getBirimSira()
    {
        return $this->BirimSira;
    }
    /**
     * Set BirimSira value
     * @param string $birimSira
     * @return \StructType\ClsSharedKarmaKoli
     */
    public function setBirimSira($birimSira = null)
    {
        // validation for constraint: string
        if (!is_null($birimSira) && !is_string($birimSira)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($birimSira, true), gettype($birimSira)), __LINE__);
        }
        $this->BirimSira = $birimSira;
        return $this;
    }
    /**
     * Get Miktar value
     * @return float
     */
    public function getMiktar()
    {
        return $this->Miktar;
    }
    /**
     * Set Miktar value
     * @param float $miktar
     * @return \StructType\ClsSharedKarmaKoli
     */
    public function setMiktar($miktar = null)
    {
        // validation for constraint: float
        if (!is_null($miktar) && !(is_float($miktar) || is_numeric($miktar))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($miktar, true), gettype($miktar)), __LINE__);
        }
        $this->Miktar = $miktar;
        return $this;
    }
    /**
     * Get Fiyat value
     * @return float
     */
    public function getFiyat()
    {
        return $this->Fiyat;
    }
    /**
     * Set Fiyat value
     * @param float $fiyat
     * @return \StructType\ClsSharedKarmaKoli
     */
    public function setFiyat($fiyat = null)
    {
        // validation for constraint: float
        if (!is_null($fiyat) && !(is_float($fiyat) || is_numeric($fiyat))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($fiyat, true), gettype($fiyat)), __LINE__);
        }
        $this->Fiyat = $fiyat;
        return $this;
    }
    /**
     * Get AlisFiyat value
     * @return float
     */
    public function getAlisFiyat()
    {
        return $this->AlisFiyat;
    }
    /**
     * Set AlisFiyat value
     * @param float $alisFiyat
     * @return \StructType\ClsSharedKarmaKoli
     */
    public function setAlisFiyat($alisFiyat = null)
    {
        // validation for constraint: float
        if (!is_null($alisFiyat) && !(is_float($alisFiyat) || is_numeric($alisFiyat))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($alisFiyat, true), gettype($alisFiyat)), __LINE__);
        }
        $this->AlisFiyat = $alisFiyat;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ClsSharedKarmaKoli
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
