<?php

namespace EnumType;

/**
 * This class stands for clsERKayitDBDurum EnumType
 * @subpackage Enumerations
 */
class ClsERKayitDBDurum
{
    /**
     * Constant for value 'Inserted'
     * @return string 'Inserted'
     */
    const VALUE_INSERTED = 'Inserted';
    /**
     * Constant for value 'Updated'
     * @return string 'Updated'
     */
    const VALUE_UPDATED = 'Updated';
    /**
     * Constant for value 'Deleted'
     * @return string 'Deleted'
     */
    const VALUE_DELETED = 'Deleted';
    /**
     * Constant for value 'NoChanges'
     * @return string 'NoChanges'
     */
    const VALUE_NO_CHANGES = 'NoChanges';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_INSERTED
     * @uses self::VALUE_UPDATED
     * @uses self::VALUE_DELETED
     * @uses self::VALUE_NO_CHANGES
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_INSERTED,
            self::VALUE_UPDATED,
            self::VALUE_DELETED,
            self::VALUE_NO_CHANGES,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
