<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for clsYasakliUrunBaslik StructType
 * @subpackage Structs
 */
class ClsYasakliUrunBaslik extends ClsERYasakliUrunBaslik
{
    /**
     * The Sonislemtarihi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Sonislemtarihi;
    /**
     * The Ilkkullanicikod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Ilkkullanicikod;
    /**
     * The Sonkullanicikod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Sonkullanicikod;
    /**
     * The UygulamaYeri
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $UygulamaYeri;
    /**
     * The Sonislemhost
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Sonislemhost;
    /**
     * The Referans
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Referans;
    /**
     * The StKriter
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StKriter;
    /**
     * Constructor method for clsYasakliUrunBaslik
     * @uses ClsYasakliUrunBaslik::setSonislemtarihi()
     * @uses ClsYasakliUrunBaslik::setIlkkullanicikod()
     * @uses ClsYasakliUrunBaslik::setSonkullanicikod()
     * @uses ClsYasakliUrunBaslik::setUygulamaYeri()
     * @uses ClsYasakliUrunBaslik::setSonislemhost()
     * @uses ClsYasakliUrunBaslik::setReferans()
     * @uses ClsYasakliUrunBaslik::setStKriter()
     * @param string $sonislemtarihi
     * @param int $ilkkullanicikod
     * @param int $sonkullanicikod
     * @param string $uygulamaYeri
     * @param string $sonislemhost
     * @param string $referans
     * @param string $stKriter
     */
    public function __construct($sonislemtarihi = null, $ilkkullanicikod = null, $sonkullanicikod = null, $uygulamaYeri = null, $sonislemhost = null, $referans = null, $stKriter = null)
    {
        $this
            ->setSonislemtarihi($sonislemtarihi)
            ->setIlkkullanicikod($ilkkullanicikod)
            ->setSonkullanicikod($sonkullanicikod)
            ->setUygulamaYeri($uygulamaYeri)
            ->setSonislemhost($sonislemhost)
            ->setReferans($referans)
            ->setStKriter($stKriter);
    }
    /**
     * Get Sonislemtarihi value
     * @return string
     */
    public function getSonislemtarihi()
    {
        return $this->Sonislemtarihi;
    }
    /**
     * Set Sonislemtarihi value
     * @param string $sonislemtarihi
     * @return \StructType\ClsYasakliUrunBaslik
     */
    public function setSonislemtarihi($sonislemtarihi = null)
    {
        // validation for constraint: string
        if (!is_null($sonislemtarihi) && !is_string($sonislemtarihi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sonislemtarihi, true), gettype($sonislemtarihi)), __LINE__);
        }
        $this->Sonislemtarihi = $sonislemtarihi;
        return $this;
    }
    /**
     * Get Ilkkullanicikod value
     * @return int
     */
    public function getIlkkullanicikod()
    {
        return $this->Ilkkullanicikod;
    }
    /**
     * Set Ilkkullanicikod value
     * @param int $ilkkullanicikod
     * @return \StructType\ClsYasakliUrunBaslik
     */
    public function setIlkkullanicikod($ilkkullanicikod = null)
    {
        // validation for constraint: int
        if (!is_null($ilkkullanicikod) && !(is_int($ilkkullanicikod) || ctype_digit($ilkkullanicikod))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ilkkullanicikod, true), gettype($ilkkullanicikod)), __LINE__);
        }
        $this->Ilkkullanicikod = $ilkkullanicikod;
        return $this;
    }
    /**
     * Get Sonkullanicikod value
     * @return int
     */
    public function getSonkullanicikod()
    {
        return $this->Sonkullanicikod;
    }
    /**
     * Set Sonkullanicikod value
     * @param int $sonkullanicikod
     * @return \StructType\ClsYasakliUrunBaslik
     */
    public function setSonkullanicikod($sonkullanicikod = null)
    {
        // validation for constraint: int
        if (!is_null($sonkullanicikod) && !(is_int($sonkullanicikod) || ctype_digit($sonkullanicikod))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sonkullanicikod, true), gettype($sonkullanicikod)), __LINE__);
        }
        $this->Sonkullanicikod = $sonkullanicikod;
        return $this;
    }
    /**
     * Get UygulamaYeri value
     * @return string
     */
    public function getUygulamaYeri()
    {
        return $this->UygulamaYeri;
    }
    /**
     * Set UygulamaYeri value
     * @param string $uygulamaYeri
     * @return \StructType\ClsYasakliUrunBaslik
     */
    public function setUygulamaYeri($uygulamaYeri = null)
    {
        // validation for constraint: string
        if (!is_null($uygulamaYeri) && !is_string($uygulamaYeri)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uygulamaYeri, true), gettype($uygulamaYeri)), __LINE__);
        }
        $this->UygulamaYeri = $uygulamaYeri;
        return $this;
    }
    /**
     * Get Sonislemhost value
     * @return string|null
     */
    public function getSonislemhost()
    {
        return $this->Sonislemhost;
    }
    /**
     * Set Sonislemhost value
     * @param string $sonislemhost
     * @return \StructType\ClsYasakliUrunBaslik
     */
    public function setSonislemhost($sonislemhost = null)
    {
        // validation for constraint: string
        if (!is_null($sonislemhost) && !is_string($sonislemhost)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sonislemhost, true), gettype($sonislemhost)), __LINE__);
        }
        $this->Sonislemhost = $sonislemhost;
        return $this;
    }
    /**
     * Get Referans value
     * @return string|null
     */
    public function getReferans()
    {
        return $this->Referans;
    }
    /**
     * Set Referans value
     * @param string $referans
     * @return \StructType\ClsYasakliUrunBaslik
     */
    public function setReferans($referans = null)
    {
        // validation for constraint: string
        if (!is_null($referans) && !is_string($referans)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referans, true), gettype($referans)), __LINE__);
        }
        $this->Referans = $referans;
        return $this;
    }
    /**
     * Get StKriter value
     * @return string|null
     */
    public function getStKriter()
    {
        return $this->StKriter;
    }
    /**
     * Set StKriter value
     * @param string $stKriter
     * @return \StructType\ClsYasakliUrunBaslik
     */
    public function setStKriter($stKriter = null)
    {
        // validation for constraint: string
        if (!is_null($stKriter) && !is_string($stKriter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stKriter, true), gettype($stKriter)), __LINE__);
        }
        $this->StKriter = $stKriter;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ClsYasakliUrunBaslik
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
