<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for clsSharedParaBirimi StructType
 * @subpackage Structs
 */
class ClsSharedParaBirimi extends ClsEntity
{
    /**
     * The Kod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Kod;
    /**
     * The SimgeKod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $SimgeKod;
    /**
     * The Aciklama
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Aciklama;
    /**
     * The Simge
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Simge;
    /**
     * The AltBirim
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AltBirim;
    /**
     * Constructor method for clsSharedParaBirimi
     * @uses ClsSharedParaBirimi::setKod()
     * @uses ClsSharedParaBirimi::setSimgeKod()
     * @uses ClsSharedParaBirimi::setAciklama()
     * @uses ClsSharedParaBirimi::setSimge()
     * @uses ClsSharedParaBirimi::setAltBirim()
     * @param string $kod
     * @param int $simgeKod
     * @param string $aciklama
     * @param string $simge
     * @param string $altBirim
     */
    public function __construct($kod = null, $simgeKod = null, $aciklama = null, $simge = null, $altBirim = null)
    {
        $this
            ->setKod($kod)
            ->setSimgeKod($simgeKod)
            ->setAciklama($aciklama)
            ->setSimge($simge)
            ->setAltBirim($altBirim);
    }
    /**
     * Get Kod value
     * @return string
     */
    public function getKod()
    {
        return $this->Kod;
    }
    /**
     * Set Kod value
     * @param string $kod
     * @return \StructType\ClsSharedParaBirimi
     */
    public function setKod($kod = null)
    {
        // validation for constraint: string
        if (!is_null($kod) && !is_string($kod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kod, true), gettype($kod)), __LINE__);
        }
        $this->Kod = $kod;
        return $this;
    }
    /**
     * Get SimgeKod value
     * @return int
     */
    public function getSimgeKod()
    {
        return $this->SimgeKod;
    }
    /**
     * Set SimgeKod value
     * @param int $simgeKod
     * @return \StructType\ClsSharedParaBirimi
     */
    public function setSimgeKod($simgeKod = null)
    {
        // validation for constraint: int
        if (!is_null($simgeKod) && !(is_int($simgeKod) || ctype_digit($simgeKod))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($simgeKod, true), gettype($simgeKod)), __LINE__);
        }
        $this->SimgeKod = $simgeKod;
        return $this;
    }
    /**
     * Get Aciklama value
     * @return string|null
     */
    public function getAciklama()
    {
        return $this->Aciklama;
    }
    /**
     * Set Aciklama value
     * @param string $aciklama
     * @return \StructType\ClsSharedParaBirimi
     */
    public function setAciklama($aciklama = null)
    {
        // validation for constraint: string
        if (!is_null($aciklama) && !is_string($aciklama)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aciklama, true), gettype($aciklama)), __LINE__);
        }
        $this->Aciklama = $aciklama;
        return $this;
    }
    /**
     * Get Simge value
     * @return string|null
     */
    public function getSimge()
    {
        return $this->Simge;
    }
    /**
     * Set Simge value
     * @param string $simge
     * @return \StructType\ClsSharedParaBirimi
     */
    public function setSimge($simge = null)
    {
        // validation for constraint: string
        if (!is_null($simge) && !is_string($simge)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($simge, true), gettype($simge)), __LINE__);
        }
        $this->Simge = $simge;
        return $this;
    }
    /**
     * Get AltBirim value
     * @return string|null
     */
    public function getAltBirim()
    {
        return $this->AltBirim;
    }
    /**
     * Set AltBirim value
     * @param string $altBirim
     * @return \StructType\ClsSharedParaBirimi
     */
    public function setAltBirim($altBirim = null)
    {
        // validation for constraint: string
        if (!is_null($altBirim) && !is_string($altBirim)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($altBirim, true), gettype($altBirim)), __LINE__);
        }
        $this->AltBirim = $altBirim;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ClsSharedParaBirimi
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
