<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for clsSharedIrsaliye StructType
 * @subpackage Structs
 */
class ClsSharedIrsaliye extends ClsSharedBelge
{
    /**
     * The Sipariskod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Sipariskod;
    /**
     * The Faturakod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Faturakod;
    /**
     * The Maltalepkod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Maltalepkod;
    /**
     * The SevkDurum
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $SevkDurum;
    /**
     * The DagiticiIptalNeden
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $DagiticiIptalNeden;
    /**
     * The IptalFaturaKod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $IptalFaturaKod;
    /**
     * The Eirsaliye
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Eirsaliye;
    /**
     * The OnSatisKod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $OnSatisKod;
    /**
     * The EarsivNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EarsivNo;
    /**
     * The EarsivUuid
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EarsivUuid;
    /**
     * Constructor method for clsSharedIrsaliye
     * @uses ClsSharedIrsaliye::setSipariskod()
     * @uses ClsSharedIrsaliye::setFaturakod()
     * @uses ClsSharedIrsaliye::setMaltalepkod()
     * @uses ClsSharedIrsaliye::setSevkDurum()
     * @uses ClsSharedIrsaliye::setDagiticiIptalNeden()
     * @uses ClsSharedIrsaliye::setIptalFaturaKod()
     * @uses ClsSharedIrsaliye::setEirsaliye()
     * @uses ClsSharedIrsaliye::setOnSatisKod()
     * @uses ClsSharedIrsaliye::setEarsivNo()
     * @uses ClsSharedIrsaliye::setEarsivUuid()
     * @param int $sipariskod
     * @param int $faturakod
     * @param int $maltalepkod
     * @param string $sevkDurum
     * @param int $dagiticiIptalNeden
     * @param int $iptalFaturaKod
     * @param string $eirsaliye
     * @param int $onSatisKod
     * @param string $earsivNo
     * @param string $earsivUuid
     */
    public function __construct($sipariskod = null, $faturakod = null, $maltalepkod = null, $sevkDurum = null, $dagiticiIptalNeden = null, $iptalFaturaKod = null, $eirsaliye = null, $onSatisKod = null, $earsivNo = null, $earsivUuid = null)
    {
        $this
            ->setSipariskod($sipariskod)
            ->setFaturakod($faturakod)
            ->setMaltalepkod($maltalepkod)
            ->setSevkDurum($sevkDurum)
            ->setDagiticiIptalNeden($dagiticiIptalNeden)
            ->setIptalFaturaKod($iptalFaturaKod)
            ->setEirsaliye($eirsaliye)
            ->setOnSatisKod($onSatisKod)
            ->setEarsivNo($earsivNo)
            ->setEarsivUuid($earsivUuid);
    }
    /**
     * Get Sipariskod value
     * @return int
     */
    public function getSipariskod()
    {
        return $this->Sipariskod;
    }
    /**
     * Set Sipariskod value
     * @param int $sipariskod
     * @return \StructType\ClsSharedIrsaliye
     */
    public function setSipariskod($sipariskod = null)
    {
        // validation for constraint: int
        if (!is_null($sipariskod) && !(is_int($sipariskod) || ctype_digit($sipariskod))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sipariskod, true), gettype($sipariskod)), __LINE__);
        }
        $this->Sipariskod = $sipariskod;
        return $this;
    }
    /**
     * Get Faturakod value
     * @return int
     */
    public function getFaturakod()
    {
        return $this->Faturakod;
    }
    /**
     * Set Faturakod value
     * @param int $faturakod
     * @return \StructType\ClsSharedIrsaliye
     */
    public function setFaturakod($faturakod = null)
    {
        // validation for constraint: int
        if (!is_null($faturakod) && !(is_int($faturakod) || ctype_digit($faturakod))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($faturakod, true), gettype($faturakod)), __LINE__);
        }
        $this->Faturakod = $faturakod;
        return $this;
    }
    /**
     * Get Maltalepkod value
     * @return int
     */
    public function getMaltalepkod()
    {
        return $this->Maltalepkod;
    }
    /**
     * Set Maltalepkod value
     * @param int $maltalepkod
     * @return \StructType\ClsSharedIrsaliye
     */
    public function setMaltalepkod($maltalepkod = null)
    {
        // validation for constraint: int
        if (!is_null($maltalepkod) && !(is_int($maltalepkod) || ctype_digit($maltalepkod))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maltalepkod, true), gettype($maltalepkod)), __LINE__);
        }
        $this->Maltalepkod = $maltalepkod;
        return $this;
    }
    /**
     * Get SevkDurum value
     * @return string
     */
    public function getSevkDurum()
    {
        return $this->SevkDurum;
    }
    /**
     * Set SevkDurum value
     * @param string $sevkDurum
     * @return \StructType\ClsSharedIrsaliye
     */
    public function setSevkDurum($sevkDurum = null)
    {
        // validation for constraint: string
        if (!is_null($sevkDurum) && !is_string($sevkDurum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sevkDurum, true), gettype($sevkDurum)), __LINE__);
        }
        $this->SevkDurum = $sevkDurum;
        return $this;
    }
    /**
     * Get DagiticiIptalNeden value
     * @return int
     */
    public function getDagiticiIptalNeden()
    {
        return $this->DagiticiIptalNeden;
    }
    /**
     * Set DagiticiIptalNeden value
     * @param int $dagiticiIptalNeden
     * @return \StructType\ClsSharedIrsaliye
     */
    public function setDagiticiIptalNeden($dagiticiIptalNeden = null)
    {
        // validation for constraint: int
        if (!is_null($dagiticiIptalNeden) && !(is_int($dagiticiIptalNeden) || ctype_digit($dagiticiIptalNeden))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($dagiticiIptalNeden, true), gettype($dagiticiIptalNeden)), __LINE__);
        }
        $this->DagiticiIptalNeden = $dagiticiIptalNeden;
        return $this;
    }
    /**
     * Get IptalFaturaKod value
     * @return int
     */
    public function getIptalFaturaKod()
    {
        return $this->IptalFaturaKod;
    }
    /**
     * Set IptalFaturaKod value
     * @param int $iptalFaturaKod
     * @return \StructType\ClsSharedIrsaliye
     */
    public function setIptalFaturaKod($iptalFaturaKod = null)
    {
        // validation for constraint: int
        if (!is_null($iptalFaturaKod) && !(is_int($iptalFaturaKod) || ctype_digit($iptalFaturaKod))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iptalFaturaKod, true), gettype($iptalFaturaKod)), __LINE__);
        }
        $this->IptalFaturaKod = $iptalFaturaKod;
        return $this;
    }
    /**
     * Get Eirsaliye value
     * @return string
     */
    public function getEirsaliye()
    {
        return $this->Eirsaliye;
    }
    /**
     * Set Eirsaliye value
     * @param string $eirsaliye
     * @return \StructType\ClsSharedIrsaliye
     */
    public function setEirsaliye($eirsaliye = null)
    {
        // validation for constraint: string
        if (!is_null($eirsaliye) && !is_string($eirsaliye)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eirsaliye, true), gettype($eirsaliye)), __LINE__);
        }
        $this->Eirsaliye = $eirsaliye;
        return $this;
    }
    /**
     * Get OnSatisKod value
     * @return int
     */
    public function getOnSatisKod()
    {
        return $this->OnSatisKod;
    }
    /**
     * Set OnSatisKod value
     * @param int $onSatisKod
     * @return \StructType\ClsSharedIrsaliye
     */
    public function setOnSatisKod($onSatisKod = null)
    {
        // validation for constraint: int
        if (!is_null($onSatisKod) && !(is_int($onSatisKod) || ctype_digit($onSatisKod))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($onSatisKod, true), gettype($onSatisKod)), __LINE__);
        }
        $this->OnSatisKod = $onSatisKod;
        return $this;
    }
    /**
     * Get EarsivNo value
     * @return string|null
     */
    public function getEarsivNo()
    {
        return $this->EarsivNo;
    }
    /**
     * Set EarsivNo value
     * @param string $earsivNo
     * @return \StructType\ClsSharedIrsaliye
     */
    public function setEarsivNo($earsivNo = null)
    {
        // validation for constraint: string
        if (!is_null($earsivNo) && !is_string($earsivNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($earsivNo, true), gettype($earsivNo)), __LINE__);
        }
        $this->EarsivNo = $earsivNo;
        return $this;
    }
    /**
     * Get EarsivUuid value
     * @return string|null
     */
    public function getEarsivUuid()
    {
        return $this->EarsivUuid;
    }
    /**
     * Set EarsivUuid value
     * @param string $earsivUuid
     * @return \StructType\ClsSharedIrsaliye
     */
    public function setEarsivUuid($earsivUuid = null)
    {
        // validation for constraint: string
        if (!is_null($earsivUuid) && !is_string($earsivUuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($earsivUuid, true), gettype($earsivUuid)), __LINE__);
        }
        $this->EarsivUuid = $earsivUuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ClsSharedIrsaliye
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
