<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for clsBilgiHazirlamaKriter StructType
 * @subpackage Structs
 */
class ClsBilgiHazirlamaKriter extends AbstractStructBase
{
    /**
     * The BaslangicTarihi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $BaslangicTarihi;
    /**
     * The BitisTarihi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $BitisTarihi;
    /**
     * The PaketTip
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $PaketTip;
    /**
     * The Kaynak
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Kaynak;
    /**
     * The DistKodlar
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfInt
     */
    public $DistKodlar;
    /**
     * The LocalFtpPath
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LocalFtpPath;
    /**
     * The DatabaseKriter
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ClsDatabaseKriter
     */
    public $DatabaseKriter;
    /**
     * The MailKriter
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ClsMailKriter
     */
    public $MailKriter;
    /**
     * The SonucMailKriter
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ClsMailKriter
     */
    public $SonucMailKriter;
    /**
     * The BasariliMailKriter
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ClsMailKriter
     */
    public $BasariliMailKriter;
    /**
     * The Version
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Version;
    /**
     * The DistMailInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ClsDistMailKriter
     */
    public $DistMailInfo;
    /**
     * Constructor method for clsBilgiHazirlamaKriter
     * @uses ClsBilgiHazirlamaKriter::setBaslangicTarihi()
     * @uses ClsBilgiHazirlamaKriter::setBitisTarihi()
     * @uses ClsBilgiHazirlamaKriter::setPaketTip()
     * @uses ClsBilgiHazirlamaKriter::setKaynak()
     * @uses ClsBilgiHazirlamaKriter::setDistKodlar()
     * @uses ClsBilgiHazirlamaKriter::setLocalFtpPath()
     * @uses ClsBilgiHazirlamaKriter::setDatabaseKriter()
     * @uses ClsBilgiHazirlamaKriter::setMailKriter()
     * @uses ClsBilgiHazirlamaKriter::setSonucMailKriter()
     * @uses ClsBilgiHazirlamaKriter::setBasariliMailKriter()
     * @uses ClsBilgiHazirlamaKriter::setVersion()
     * @uses ClsBilgiHazirlamaKriter::setDistMailInfo()
     * @param string $baslangicTarihi
     * @param string $bitisTarihi
     * @param string $paketTip
     * @param string $kaynak
     * @param \ArrayType\ArrayOfInt $distKodlar
     * @param string $localFtpPath
     * @param \StructType\ClsDatabaseKriter $databaseKriter
     * @param \StructType\ClsMailKriter $mailKriter
     * @param \StructType\ClsMailKriter $sonucMailKriter
     * @param \StructType\ClsMailKriter $basariliMailKriter
     * @param string $version
     * @param \StructType\ClsDistMailKriter $distMailInfo
     */
    public function __construct($baslangicTarihi = null, $bitisTarihi = null, $paketTip = null, $kaynak = null, \ArrayType\ArrayOfInt $distKodlar = null, $localFtpPath = null, \StructType\ClsDatabaseKriter $databaseKriter = null, \StructType\ClsMailKriter $mailKriter = null, \StructType\ClsMailKriter $sonucMailKriter = null, \StructType\ClsMailKriter $basariliMailKriter = null, $version = null, \StructType\ClsDistMailKriter $distMailInfo = null)
    {
        $this
            ->setBaslangicTarihi($baslangicTarihi)
            ->setBitisTarihi($bitisTarihi)
            ->setPaketTip($paketTip)
            ->setKaynak($kaynak)
            ->setDistKodlar($distKodlar)
            ->setLocalFtpPath($localFtpPath)
            ->setDatabaseKriter($databaseKriter)
            ->setMailKriter($mailKriter)
            ->setSonucMailKriter($sonucMailKriter)
            ->setBasariliMailKriter($basariliMailKriter)
            ->setVersion($version)
            ->setDistMailInfo($distMailInfo);
    }
    /**
     * Get BaslangicTarihi value
     * @return string
     */
    public function getBaslangicTarihi()
    {
        return $this->BaslangicTarihi;
    }
    /**
     * Set BaslangicTarihi value
     * @param string $baslangicTarihi
     * @return \StructType\ClsBilgiHazirlamaKriter
     */
    public function setBaslangicTarihi($baslangicTarihi = null)
    {
        // validation for constraint: string
        if (!is_null($baslangicTarihi) && !is_string($baslangicTarihi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($baslangicTarihi, true), gettype($baslangicTarihi)), __LINE__);
        }
        $this->BaslangicTarihi = $baslangicTarihi;
        return $this;
    }
    /**
     * Get BitisTarihi value
     * @return string
     */
    public function getBitisTarihi()
    {
        return $this->BitisTarihi;
    }
    /**
     * Set BitisTarihi value
     * @param string $bitisTarihi
     * @return \StructType\ClsBilgiHazirlamaKriter
     */
    public function setBitisTarihi($bitisTarihi = null)
    {
        // validation for constraint: string
        if (!is_null($bitisTarihi) && !is_string($bitisTarihi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bitisTarihi, true), gettype($bitisTarihi)), __LINE__);
        }
        $this->BitisTarihi = $bitisTarihi;
        return $this;
    }
    /**
     * Get PaketTip value
     * @return string
     */
    public function getPaketTip()
    {
        return $this->PaketTip;
    }
    /**
     * Set PaketTip value
     * @uses \EnumType\PaketTipi::valueIsValid()
     * @uses \EnumType\PaketTipi::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $paketTip
     * @return \StructType\ClsBilgiHazirlamaKriter
     */
    public function setPaketTip($paketTip = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PaketTipi::valueIsValid($paketTip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PaketTipi', is_array($paketTip) ? implode(', ', $paketTip) : var_export($paketTip, true), implode(', ', \EnumType\PaketTipi::getValidValues())), __LINE__);
        }
        $this->PaketTip = $paketTip;
        return $this;
    }
    /**
     * Get Kaynak value
     * @return string
     */
    public function getKaynak()
    {
        return $this->Kaynak;
    }
    /**
     * Set Kaynak value
     * @uses \EnumType\GorevKaynak::valueIsValid()
     * @uses \EnumType\GorevKaynak::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $kaynak
     * @return \StructType\ClsBilgiHazirlamaKriter
     */
    public function setKaynak($kaynak = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\GorevKaynak::valueIsValid($kaynak)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\GorevKaynak', is_array($kaynak) ? implode(', ', $kaynak) : var_export($kaynak, true), implode(', ', \EnumType\GorevKaynak::getValidValues())), __LINE__);
        }
        $this->Kaynak = $kaynak;
        return $this;
    }
    /**
     * Get DistKodlar value
     * @return \ArrayType\ArrayOfInt|null
     */
    public function getDistKodlar()
    {
        return $this->DistKodlar;
    }
    /**
     * Set DistKodlar value
     * @param \ArrayType\ArrayOfInt $distKodlar
     * @return \StructType\ClsBilgiHazirlamaKriter
     */
    public function setDistKodlar(\ArrayType\ArrayOfInt $distKodlar = null)
    {
        $this->DistKodlar = $distKodlar;
        return $this;
    }
    /**
     * Get LocalFtpPath value
     * @return string|null
     */
    public function getLocalFtpPath()
    {
        return $this->LocalFtpPath;
    }
    /**
     * Set LocalFtpPath value
     * @param string $localFtpPath
     * @return \StructType\ClsBilgiHazirlamaKriter
     */
    public function setLocalFtpPath($localFtpPath = null)
    {
        // validation for constraint: string
        if (!is_null($localFtpPath) && !is_string($localFtpPath)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($localFtpPath, true), gettype($localFtpPath)), __LINE__);
        }
        $this->LocalFtpPath = $localFtpPath;
        return $this;
    }
    /**
     * Get DatabaseKriter value
     * @return \StructType\ClsDatabaseKriter|null
     */
    public function getDatabaseKriter()
    {
        return $this->DatabaseKriter;
    }
    /**
     * Set DatabaseKriter value
     * @param \StructType\ClsDatabaseKriter $databaseKriter
     * @return \StructType\ClsBilgiHazirlamaKriter
     */
    public function setDatabaseKriter(\StructType\ClsDatabaseKriter $databaseKriter = null)
    {
        $this->DatabaseKriter = $databaseKriter;
        return $this;
    }
    /**
     * Get MailKriter value
     * @return \StructType\ClsMailKriter|null
     */
    public function getMailKriter()
    {
        return $this->MailKriter;
    }
    /**
     * Set MailKriter value
     * @param \StructType\ClsMailKriter $mailKriter
     * @return \StructType\ClsBilgiHazirlamaKriter
     */
    public function setMailKriter(\StructType\ClsMailKriter $mailKriter = null)
    {
        $this->MailKriter = $mailKriter;
        return $this;
    }
    /**
     * Get SonucMailKriter value
     * @return \StructType\ClsMailKriter|null
     */
    public function getSonucMailKriter()
    {
        return $this->SonucMailKriter;
    }
    /**
     * Set SonucMailKriter value
     * @param \StructType\ClsMailKriter $sonucMailKriter
     * @return \StructType\ClsBilgiHazirlamaKriter
     */
    public function setSonucMailKriter(\StructType\ClsMailKriter $sonucMailKriter = null)
    {
        $this->SonucMailKriter = $sonucMailKriter;
        return $this;
    }
    /**
     * Get BasariliMailKriter value
     * @return \StructType\ClsMailKriter|null
     */
    public function getBasariliMailKriter()
    {
        return $this->BasariliMailKriter;
    }
    /**
     * Set BasariliMailKriter value
     * @param \StructType\ClsMailKriter $basariliMailKriter
     * @return \StructType\ClsBilgiHazirlamaKriter
     */
    public function setBasariliMailKriter(\StructType\ClsMailKriter $basariliMailKriter = null)
    {
        $this->BasariliMailKriter = $basariliMailKriter;
        return $this;
    }
    /**
     * Get Version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param string $version
     * @return \StructType\ClsBilgiHazirlamaKriter
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->Version = $version;
        return $this;
    }
    /**
     * Get DistMailInfo value
     * @return \StructType\ClsDistMailKriter|null
     */
    public function getDistMailInfo()
    {
        return $this->DistMailInfo;
    }
    /**
     * Set DistMailInfo value
     * @param \StructType\ClsDistMailKriter $distMailInfo
     * @return \StructType\ClsBilgiHazirlamaKriter
     */
    public function setDistMailInfo(\StructType\ClsDistMailKriter $distMailInfo = null)
    {
        $this->DistMailInfo = $distMailInfo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ClsBilgiHazirlamaKriter
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
