<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Integration ServiceType
 * @subpackage Services
 */
class Integration extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named IntegrationSendEntitySetWithLogin
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\IntegrationSendEntitySetWithLogin $parameters
     * @return \StructType\IntegrationSendEntitySetWithLoginResponse|bool
     */
    public function IntegrationSendEntitySetWithLogin(\StructType\IntegrationSendEntitySetWithLogin $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->IntegrationSendEntitySetWithLogin($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * IntegrationSendCancelledEntitySetWithLogin
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\IntegrationSendCancelledEntitySetWithLogin $parameters
     * @return \StructType\IntegrationSendCancelledEntitySetWithLoginResponse|bool
     */
    public function IntegrationSendCancelledEntitySetWithLogin(\StructType\IntegrationSendCancelledEntitySetWithLogin $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->IntegrationSendCancelledEntitySetWithLogin($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named IntegrationLogin
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\IntegrationLogin $parameters
     * @return \StructType\IntegrationLoginResponse|bool
     */
    public function IntegrationLogin(\StructType\IntegrationLogin $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->IntegrationLogin($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named IntegrationLogout
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\IntegrationLogout $parameters
     * @return \StructType\IntegrationLogoutResponse|bool
     */
    public function IntegrationLogout(\StructType\IntegrationLogout $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->IntegrationLogout($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named IntegrationSendEntitySet
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\IntegrationSendEntitySet $parameters
     * @return \StructType\IntegrationSendEntitySetResponse|bool
     */
    public function IntegrationSendEntitySet(\StructType\IntegrationSendEntitySet $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->IntegrationSendEntitySet($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named IntegrationGetEntitySet
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\IntegrationGetEntitySet $parameters
     * @return \StructType\IntegrationGetEntitySetResponse|bool
     */
    public function IntegrationGetEntitySet(\StructType\IntegrationGetEntitySet $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->IntegrationGetEntitySet($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named IntegrationGetEntitySetWithLogin
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\IntegrationGetEntitySetWithLogin $parameters
     * @return \StructType\IntegrationGetEntitySetWithLoginResponse|bool
     */
    public function IntegrationGetEntitySetWithLogin(\StructType\IntegrationGetEntitySetWithLogin $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->IntegrationGetEntitySetWithLogin($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * IntegrationGetEntitySetWithPacketLogin
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\IntegrationGetEntitySetWithPacketLogin $parameters
     * @return \StructType\IntegrationGetEntitySetWithPacketLoginResponse|bool
     */
    public function IntegrationGetEntitySetWithPacketLogin(\StructType\IntegrationGetEntitySetWithPacketLogin $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->IntegrationGetEntitySetWithPacketLogin($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named IntegrationSendSuccessResult
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\IntegrationSendSuccessResult $parameters
     * @return \StructType\IntegrationSendSuccessResultResponse|bool
     */
    public function IntegrationSendSuccessResult(\StructType\IntegrationSendSuccessResult $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->IntegrationSendSuccessResult($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named IntegrationDeleteTransferStatus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\IntegrationDeleteTransferStatus $parameters
     * @return \StructType\IntegrationDeleteTransferStatusResponse|bool
     */
    public function IntegrationDeleteTransferStatus(\StructType\IntegrationDeleteTransferStatus $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->IntegrationDeleteTransferStatus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named IntegrationSendUpdateRecord
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\IntegrationSendUpdateRecord $parameters
     * @return \StructType\IntegrationSendUpdateRecordResponse|bool
     */
    public function IntegrationSendUpdateRecord(\StructType\IntegrationSendUpdateRecord $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->IntegrationSendUpdateRecord($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * IntegrationSendUpdateRecordWithCode
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\IntegrationSendUpdateRecordWithCode $parameters
     * @return \StructType\IntegrationSendUpdateRecordWithCodeResponse|bool
     */
    public function IntegrationSendUpdateRecordWithCode(\StructType\IntegrationSendUpdateRecordWithCode $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->IntegrationSendUpdateRecordWithCode($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named IntegrationSendCollectionPaid
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\IntegrationSendCollectionPaid $parameters
     * @return \StructType\IntegrationSendCollectionPaidResponse|bool
     */
    public function IntegrationSendCollectionPaid(\StructType\IntegrationSendCollectionPaid $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->IntegrationSendCollectionPaid($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\IntegrationDeleteTransferStatusResponse|\StructType\IntegrationGetEntitySetResponse|\StructType\IntegrationGetEntitySetWithLoginResponse|\StructType\IntegrationGetEntitySetWithPacketLoginResponse|\StructType\IntegrationLoginResponse|\StructType\IntegrationLogoutResponse|\StructType\IntegrationSendCancelledEntitySetWithLoginResponse|\StructType\IntegrationSendCollectionPaidResponse|\StructType\IntegrationSendEntitySetResponse|\StructType\IntegrationSendEntitySetWithLoginResponse|\StructType\IntegrationSendSuccessResultResponse|\StructType\IntegrationSendUpdateRecordResponse|\StructType\IntegrationSendUpdateRecordWithCodeResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
