<?php

namespace EnumType;

/**
 * This class stands for KarmaKoliAktarimTipi EnumType
 * @subpackage Enumerations
 */
class KarmaKoliAktarimTipi
{
    /**
     * Constant for value 'KKDetayUrunleriAktar'
     * @return string 'KKDetayUrunleriAktar'
     */
    const VALUE_KKDETAY_URUNLERI_AKTAR = 'KKDetayUrunleriAktar';
    /**
     * Constant for value 'KKAnaUrunuAktar'
     * @return string 'KKAnaUrunuAktar'
     */
    const VALUE_KKANA_URUNU_AKTAR = 'KKAnaUrunuAktar';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_KKDETAY_URUNLERI_AKTAR
     * @uses self::VALUE_KKANA_URUNU_AKTAR
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_KKDETAY_URUNLERI_AKTAR,
            self::VALUE_KKANA_URUNU_AKTAR,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
