<?php

namespace EnumType;

/**
 * This class stands for clsErDemirbasKontrolDurum EnumType
 * @subpackage Enumerations
 */
class ClsErDemirbasKontrolDurum
{
    /**
     * Constant for value 'Bekliyor'
     * @return string 'Bekliyor'
     */
    const VALUE_BEKLIYOR = 'Bekliyor';
    /**
     * Constant for value 'Yerinde'
     * @return string 'Yerinde'
     */
    const VALUE_YERINDE = 'Yerinde';
    /**
     * Constant for value 'YerindeDegil'
     * @return string 'YerindeDegil'
     */
    const VALUE_YERINDE_DEGIL = 'YerindeDegil';
    /**
     * Constant for value 'Yeni'
     * @return string 'Yeni'
     */
    const VALUE_YENI = 'Yeni';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_BEKLIYOR
     * @uses self::VALUE_YERINDE
     * @uses self::VALUE_YERINDE_DEGIL
     * @uses self::VALUE_YENI
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_BEKLIYOR,
            self::VALUE_YERINDE,
            self::VALUE_YERINDE_DEGIL,
            self::VALUE_YENI,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
