<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for clsSharedVergiDairesi StructType
 * @subpackage Structs
 */
class ClsSharedVergiDairesi extends ClsEntity
{
    /**
     * The Kod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Kod;
    /**
     * The Ilkod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Ilkod;
    /**
     * The Ilcekod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Ilcekod;
    /**
     * The Ad
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Ad;
    /**
     * Constructor method for clsSharedVergiDairesi
     * @uses ClsSharedVergiDairesi::setKod()
     * @uses ClsSharedVergiDairesi::setIlkod()
     * @uses ClsSharedVergiDairesi::setIlcekod()
     * @uses ClsSharedVergiDairesi::setAd()
     * @param int $kod
     * @param string $ilkod
     * @param int $ilcekod
     * @param string $ad
     */
    public function __construct($kod = null, $ilkod = null, $ilcekod = null, $ad = null)
    {
        $this
            ->setKod($kod)
            ->setIlkod($ilkod)
            ->setIlcekod($ilcekod)
            ->setAd($ad);
    }
    /**
     * Get Kod value
     * @return int
     */
    public function getKod()
    {
        return $this->Kod;
    }
    /**
     * Set Kod value
     * @param int $kod
     * @return \StructType\ClsSharedVergiDairesi
     */
    public function setKod($kod = null)
    {
        // validation for constraint: int
        if (!is_null($kod) && !(is_int($kod) || ctype_digit($kod))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($kod, true), gettype($kod)), __LINE__);
        }
        $this->Kod = $kod;
        return $this;
    }
    /**
     * Get Ilkod value
     * @return string
     */
    public function getIlkod()
    {
        return $this->Ilkod;
    }
    /**
     * Set Ilkod value
     * @param string $ilkod
     * @return \StructType\ClsSharedVergiDairesi
     */
    public function setIlkod($ilkod = null)
    {
        // validation for constraint: string
        if (!is_null($ilkod) && !is_string($ilkod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ilkod, true), gettype($ilkod)), __LINE__);
        }
        $this->Ilkod = $ilkod;
        return $this;
    }
    /**
     * Get Ilcekod value
     * @return int
     */
    public function getIlcekod()
    {
        return $this->Ilcekod;
    }
    /**
     * Set Ilcekod value
     * @param int $ilcekod
     * @return \StructType\ClsSharedVergiDairesi
     */
    public function setIlcekod($ilcekod = null)
    {
        // validation for constraint: int
        if (!is_null($ilcekod) && !(is_int($ilcekod) || ctype_digit($ilcekod))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ilcekod, true), gettype($ilcekod)), __LINE__);
        }
        $this->Ilcekod = $ilcekod;
        return $this;
    }
    /**
     * Get Ad value
     * @return string|null
     */
    public function getAd()
    {
        return $this->Ad;
    }
    /**
     * Set Ad value
     * @param string $ad
     * @return \StructType\ClsSharedVergiDairesi
     */
    public function setAd($ad = null)
    {
        // validation for constraint: string
        if (!is_null($ad) && !is_string($ad)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ad, true), gettype($ad)), __LINE__);
        }
        $this->Ad = $ad;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ClsSharedVergiDairesi
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
