<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for clsDepo StructType
 * @subpackage Structs
 */
class ClsDepo extends ClsSharedDepo
{
    /**
     * The Sonislemtarihi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Sonislemtarihi;
    /**
     * The Ilkislemtarihi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Ilkislemtarihi;
    /**
     * The Ilkkullanicikod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Ilkkullanicikod;
    /**
     * The Sonkullanicikod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Sonkullanicikod;
    /**
     * The KoordinatX
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $KoordinatX;
    /**
     * The KoordinatY
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $KoordinatY;
    /**
     * The Demirbas
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Demirbas;
    /**
     * The StokMiktarGoster
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $StokMiktarGoster;
    /**
     * The Sonislemhost
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Sonislemhost;
    /**
     * The Referans
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Referans;
    /**
     * Constructor method for clsDepo
     * @uses ClsDepo::setSonislemtarihi()
     * @uses ClsDepo::setIlkislemtarihi()
     * @uses ClsDepo::setIlkkullanicikod()
     * @uses ClsDepo::setSonkullanicikod()
     * @uses ClsDepo::setKoordinatX()
     * @uses ClsDepo::setKoordinatY()
     * @uses ClsDepo::setDemirbas()
     * @uses ClsDepo::setStokMiktarGoster()
     * @uses ClsDepo::setSonislemhost()
     * @uses ClsDepo::setReferans()
     * @param string $sonislemtarihi
     * @param string $ilkislemtarihi
     * @param int $ilkkullanicikod
     * @param int $sonkullanicikod
     * @param float $koordinatX
     * @param float $koordinatY
     * @param string $demirbas
     * @param string $stokMiktarGoster
     * @param string $sonislemhost
     * @param string $referans
     */
    public function __construct($sonislemtarihi = null, $ilkislemtarihi = null, $ilkkullanicikod = null, $sonkullanicikod = null, $koordinatX = null, $koordinatY = null, $demirbas = null, $stokMiktarGoster = null, $sonislemhost = null, $referans = null)
    {
        $this
            ->setSonislemtarihi($sonislemtarihi)
            ->setIlkislemtarihi($ilkislemtarihi)
            ->setIlkkullanicikod($ilkkullanicikod)
            ->setSonkullanicikod($sonkullanicikod)
            ->setKoordinatX($koordinatX)
            ->setKoordinatY($koordinatY)
            ->setDemirbas($demirbas)
            ->setStokMiktarGoster($stokMiktarGoster)
            ->setSonislemhost($sonislemhost)
            ->setReferans($referans);
    }
    /**
     * Get Sonislemtarihi value
     * @return string
     */
    public function getSonislemtarihi()
    {
        return $this->Sonislemtarihi;
    }
    /**
     * Set Sonislemtarihi value
     * @param string $sonislemtarihi
     * @return \StructType\ClsDepo
     */
    public function setSonislemtarihi($sonislemtarihi = null)
    {
        // validation for constraint: string
        if (!is_null($sonislemtarihi) && !is_string($sonislemtarihi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sonislemtarihi, true), gettype($sonislemtarihi)), __LINE__);
        }
        $this->Sonislemtarihi = $sonislemtarihi;
        return $this;
    }
    /**
     * Get Ilkislemtarihi value
     * @return string
     */
    public function getIlkislemtarihi()
    {
        return $this->Ilkislemtarihi;
    }
    /**
     * Set Ilkislemtarihi value
     * @param string $ilkislemtarihi
     * @return \StructType\ClsDepo
     */
    public function setIlkislemtarihi($ilkislemtarihi = null)
    {
        // validation for constraint: string
        if (!is_null($ilkislemtarihi) && !is_string($ilkislemtarihi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ilkislemtarihi, true), gettype($ilkislemtarihi)), __LINE__);
        }
        $this->Ilkislemtarihi = $ilkislemtarihi;
        return $this;
    }
    /**
     * Get Ilkkullanicikod value
     * @return int
     */
    public function getIlkkullanicikod()
    {
        return $this->Ilkkullanicikod;
    }
    /**
     * Set Ilkkullanicikod value
     * @param int $ilkkullanicikod
     * @return \StructType\ClsDepo
     */
    public function setIlkkullanicikod($ilkkullanicikod = null)
    {
        // validation for constraint: int
        if (!is_null($ilkkullanicikod) && !(is_int($ilkkullanicikod) || ctype_digit($ilkkullanicikod))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ilkkullanicikod, true), gettype($ilkkullanicikod)), __LINE__);
        }
        $this->Ilkkullanicikod = $ilkkullanicikod;
        return $this;
    }
    /**
     * Get Sonkullanicikod value
     * @return int
     */
    public function getSonkullanicikod()
    {
        return $this->Sonkullanicikod;
    }
    /**
     * Set Sonkullanicikod value
     * @param int $sonkullanicikod
     * @return \StructType\ClsDepo
     */
    public function setSonkullanicikod($sonkullanicikod = null)
    {
        // validation for constraint: int
        if (!is_null($sonkullanicikod) && !(is_int($sonkullanicikod) || ctype_digit($sonkullanicikod))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sonkullanicikod, true), gettype($sonkullanicikod)), __LINE__);
        }
        $this->Sonkullanicikod = $sonkullanicikod;
        return $this;
    }
    /**
     * Get KoordinatX value
     * @return float
     */
    public function getKoordinatX()
    {
        return $this->KoordinatX;
    }
    /**
     * Set KoordinatX value
     * @param float $koordinatX
     * @return \StructType\ClsDepo
     */
    public function setKoordinatX($koordinatX = null)
    {
        // validation for constraint: float
        if (!is_null($koordinatX) && !(is_float($koordinatX) || is_numeric($koordinatX))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($koordinatX, true), gettype($koordinatX)), __LINE__);
        }
        $this->KoordinatX = $koordinatX;
        return $this;
    }
    /**
     * Get KoordinatY value
     * @return float
     */
    public function getKoordinatY()
    {
        return $this->KoordinatY;
    }
    /**
     * Set KoordinatY value
     * @param float $koordinatY
     * @return \StructType\ClsDepo
     */
    public function setKoordinatY($koordinatY = null)
    {
        // validation for constraint: float
        if (!is_null($koordinatY) && !(is_float($koordinatY) || is_numeric($koordinatY))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($koordinatY, true), gettype($koordinatY)), __LINE__);
        }
        $this->KoordinatY = $koordinatY;
        return $this;
    }
    /**
     * Get Demirbas value
     * @return string
     */
    public function getDemirbas()
    {
        return $this->Demirbas;
    }
    /**
     * Set Demirbas value
     * @param string $demirbas
     * @return \StructType\ClsDepo
     */
    public function setDemirbas($demirbas = null)
    {
        // validation for constraint: string
        if (!is_null($demirbas) && !is_string($demirbas)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($demirbas, true), gettype($demirbas)), __LINE__);
        }
        $this->Demirbas = $demirbas;
        return $this;
    }
    /**
     * Get StokMiktarGoster value
     * @return string
     */
    public function getStokMiktarGoster()
    {
        return $this->StokMiktarGoster;
    }
    /**
     * Set StokMiktarGoster value
     * @param string $stokMiktarGoster
     * @return \StructType\ClsDepo
     */
    public function setStokMiktarGoster($stokMiktarGoster = null)
    {
        // validation for constraint: string
        if (!is_null($stokMiktarGoster) && !is_string($stokMiktarGoster)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stokMiktarGoster, true), gettype($stokMiktarGoster)), __LINE__);
        }
        $this->StokMiktarGoster = $stokMiktarGoster;
        return $this;
    }
    /**
     * Get Sonislemhost value
     * @return string|null
     */
    public function getSonislemhost()
    {
        return $this->Sonislemhost;
    }
    /**
     * Set Sonislemhost value
     * @param string $sonislemhost
     * @return \StructType\ClsDepo
     */
    public function setSonislemhost($sonislemhost = null)
    {
        // validation for constraint: string
        if (!is_null($sonislemhost) && !is_string($sonislemhost)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sonislemhost, true), gettype($sonislemhost)), __LINE__);
        }
        $this->Sonislemhost = $sonislemhost;
        return $this;
    }
    /**
     * Get Referans value
     * @return string|null
     */
    public function getReferans()
    {
        return $this->Referans;
    }
    /**
     * Set Referans value
     * @param string $referans
     * @return \StructType\ClsDepo
     */
    public function setReferans($referans = null)
    {
        // validation for constraint: string
        if (!is_null($referans) && !is_string($referans)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referans, true), gettype($referans)), __LINE__);
        }
        $this->Referans = $referans;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ClsDepo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
