<?php

namespace EnumType;

/**
 * This class stands for UrunAktarimKodu EnumType
 * @subpackage Enumerations
 */
class UrunAktarimKodu
{
    /**
     * Constant for value 'UrunKodTCP'
     * @return string 'UrunKodTCP'
     */
    const VALUE_URUN_KOD_TCP = 'UrunKodTCP';
    /**
     * Constant for value 'UrunKodTCP2'
     * @return string 'UrunKodTCP2'
     */
    const VALUE_URUN_KOD_TCP_2 = 'UrunKodTCP2';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_URUN_KOD_TCP
     * @uses self::VALUE_URUN_KOD_TCP_2
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_URUN_KOD_TCP,
            self::VALUE_URUN_KOD_TCP_2,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
