<?php

namespace EnumType;

/**
 * This class stands for AktarimTipi EnumType
 * @subpackage Enumerations
 */
class AktarimTipi
{
    /**
     * Constant for value 'Logo'
     * @return string 'Logo'
     */
    const VALUE_LOGO = 'Logo';
    /**
     * Constant for value 'Netsis'
     * @return string 'Netsis'
     */
    const VALUE_NETSIS = 'Netsis';
    /**
     * Constant for value 'LKS2'
     * @return string 'LKS2'
     */
    const VALUE_LKS_2 = 'LKS2';
    /**
     * Constant for value 'GenericXML'
     * @return string 'GenericXML'
     */
    const VALUE_GENERIC_XML = 'GenericXML';
    /**
     * Constant for value 'ETA'
     * @return string 'ETA'
     */
    const VALUE_ETA = 'ETA';
    /**
     * Constant for value 'GenericText'
     * @return string 'GenericText'
     */
    const VALUE_GENERIC_TEXT = 'GenericText';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_LOGO
     * @uses self::VALUE_NETSIS
     * @uses self::VALUE_LKS_2
     * @uses self::VALUE_GENERIC_XML
     * @uses self::VALUE_ETA
     * @uses self::VALUE_GENERIC_TEXT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_LOGO,
            self::VALUE_NETSIS,
            self::VALUE_LKS_2,
            self::VALUE_GENERIC_XML,
            self::VALUE_ETA,
            self::VALUE_GENERIC_TEXT,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
