<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for clsFaturaGeneric StructType
 * @subpackage Structs
 */
class ClsFaturaGeneric extends ClsBelgeGeneric
{
    /**
     * The MasrafTutari
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $MasrafTutari;
    /**
     * The UrunAdi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UrunAdi;
    /**
     * The MusteriAdi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MusteriAdi;
    /**
     * Constructor method for clsFaturaGeneric
     * @uses ClsFaturaGeneric::setMasrafTutari()
     * @uses ClsFaturaGeneric::setUrunAdi()
     * @uses ClsFaturaGeneric::setMusteriAdi()
     * @param float $masrafTutari
     * @param string $urunAdi
     * @param string $musteriAdi
     */
    public function __construct($masrafTutari = null, $urunAdi = null, $musteriAdi = null)
    {
        $this
            ->setMasrafTutari($masrafTutari)
            ->setUrunAdi($urunAdi)
            ->setMusteriAdi($musteriAdi);
    }
    /**
     * Get MasrafTutari value
     * @return float
     */
    public function getMasrafTutari()
    {
        return $this->MasrafTutari;
    }
    /**
     * Set MasrafTutari value
     * @param float $masrafTutari
     * @return \StructType\ClsFaturaGeneric
     */
    public function setMasrafTutari($masrafTutari = null)
    {
        // validation for constraint: float
        if (!is_null($masrafTutari) && !(is_float($masrafTutari) || is_numeric($masrafTutari))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($masrafTutari, true), gettype($masrafTutari)), __LINE__);
        }
        $this->MasrafTutari = $masrafTutari;
        return $this;
    }
    /**
     * Get UrunAdi value
     * @return string|null
     */
    public function getUrunAdi()
    {
        return $this->UrunAdi;
    }
    /**
     * Set UrunAdi value
     * @param string $urunAdi
     * @return \StructType\ClsFaturaGeneric
     */
    public function setUrunAdi($urunAdi = null)
    {
        // validation for constraint: string
        if (!is_null($urunAdi) && !is_string($urunAdi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($urunAdi, true), gettype($urunAdi)), __LINE__);
        }
        $this->UrunAdi = $urunAdi;
        return $this;
    }
    /**
     * Get MusteriAdi value
     * @return string|null
     */
    public function getMusteriAdi()
    {
        return $this->MusteriAdi;
    }
    /**
     * Set MusteriAdi value
     * @param string $musteriAdi
     * @return \StructType\ClsFaturaGeneric
     */
    public function setMusteriAdi($musteriAdi = null)
    {
        // validation for constraint: string
        if (!is_null($musteriAdi) && !is_string($musteriAdi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($musteriAdi, true), gettype($musteriAdi)), __LINE__);
        }
        $this->MusteriAdi = $musteriAdi;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ClsFaturaGeneric
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
