<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for clsERBelgeToplama StructType
 * @subpackage Structs
 */
class ClsERBelgeToplama extends ClsEntity
{
    /**
     * The UrunKod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $UrunKod;
    /**
     * The Miktar
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Miktar;
    /**
     * The ToplanacakMiktar
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ToplanacakMiktar;
    /**
     * The SeriTakipVar
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $SeriTakipVar;
    /**
     * The UrunTxtKod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UrunTxtKod;
    /**
     * The Aciklama
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Aciklama;
    /**
     * Constructor method for clsERBelgeToplama
     * @uses ClsERBelgeToplama::setUrunKod()
     * @uses ClsERBelgeToplama::setMiktar()
     * @uses ClsERBelgeToplama::setToplanacakMiktar()
     * @uses ClsERBelgeToplama::setSeriTakipVar()
     * @uses ClsERBelgeToplama::setUrunTxtKod()
     * @uses ClsERBelgeToplama::setAciklama()
     * @param int $urunKod
     * @param int $miktar
     * @param int $toplanacakMiktar
     * @param bool $seriTakipVar
     * @param string $urunTxtKod
     * @param string $aciklama
     */
    public function __construct($urunKod = null, $miktar = null, $toplanacakMiktar = null, $seriTakipVar = null, $urunTxtKod = null, $aciklama = null)
    {
        $this
            ->setUrunKod($urunKod)
            ->setMiktar($miktar)
            ->setToplanacakMiktar($toplanacakMiktar)
            ->setSeriTakipVar($seriTakipVar)
            ->setUrunTxtKod($urunTxtKod)
            ->setAciklama($aciklama);
    }
    /**
     * Get UrunKod value
     * @return int
     */
    public function getUrunKod()
    {
        return $this->UrunKod;
    }
    /**
     * Set UrunKod value
     * @param int $urunKod
     * @return \StructType\ClsERBelgeToplama
     */
    public function setUrunKod($urunKod = null)
    {
        // validation for constraint: int
        if (!is_null($urunKod) && !(is_int($urunKod) || ctype_digit($urunKod))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($urunKod, true), gettype($urunKod)), __LINE__);
        }
        $this->UrunKod = $urunKod;
        return $this;
    }
    /**
     * Get Miktar value
     * @return int
     */
    public function getMiktar()
    {
        return $this->Miktar;
    }
    /**
     * Set Miktar value
     * @param int $miktar
     * @return \StructType\ClsERBelgeToplama
     */
    public function setMiktar($miktar = null)
    {
        // validation for constraint: int
        if (!is_null($miktar) && !(is_int($miktar) || ctype_digit($miktar))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($miktar, true), gettype($miktar)), __LINE__);
        }
        $this->Miktar = $miktar;
        return $this;
    }
    /**
     * Get ToplanacakMiktar value
     * @return int
     */
    public function getToplanacakMiktar()
    {
        return $this->ToplanacakMiktar;
    }
    /**
     * Set ToplanacakMiktar value
     * @param int $toplanacakMiktar
     * @return \StructType\ClsERBelgeToplama
     */
    public function setToplanacakMiktar($toplanacakMiktar = null)
    {
        // validation for constraint: int
        if (!is_null($toplanacakMiktar) && !(is_int($toplanacakMiktar) || ctype_digit($toplanacakMiktar))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($toplanacakMiktar, true), gettype($toplanacakMiktar)), __LINE__);
        }
        $this->ToplanacakMiktar = $toplanacakMiktar;
        return $this;
    }
    /**
     * Get SeriTakipVar value
     * @return bool
     */
    public function getSeriTakipVar()
    {
        return $this->SeriTakipVar;
    }
    /**
     * Set SeriTakipVar value
     * @param bool $seriTakipVar
     * @return \StructType\ClsERBelgeToplama
     */
    public function setSeriTakipVar($seriTakipVar = null)
    {
        // validation for constraint: boolean
        if (!is_null($seriTakipVar) && !is_bool($seriTakipVar)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($seriTakipVar, true), gettype($seriTakipVar)), __LINE__);
        }
        $this->SeriTakipVar = $seriTakipVar;
        return $this;
    }
    /**
     * Get UrunTxtKod value
     * @return string|null
     */
    public function getUrunTxtKod()
    {
        return $this->UrunTxtKod;
    }
    /**
     * Set UrunTxtKod value
     * @param string $urunTxtKod
     * @return \StructType\ClsERBelgeToplama
     */
    public function setUrunTxtKod($urunTxtKod = null)
    {
        // validation for constraint: string
        if (!is_null($urunTxtKod) && !is_string($urunTxtKod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($urunTxtKod, true), gettype($urunTxtKod)), __LINE__);
        }
        $this->UrunTxtKod = $urunTxtKod;
        return $this;
    }
    /**
     * Get Aciklama value
     * @return string|null
     */
    public function getAciklama()
    {
        return $this->Aciklama;
    }
    /**
     * Set Aciklama value
     * @param string $aciklama
     * @return \StructType\ClsERBelgeToplama
     */
    public function setAciklama($aciklama = null)
    {
        // validation for constraint: string
        if (!is_null($aciklama) && !is_string($aciklama)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aciklama, true), gettype($aciklama)), __LINE__);
        }
        $this->Aciklama = $aciklama;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ClsERBelgeToplama
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
